/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.doublelive.OperationSyncDDLProtector;
import org.apache.iotdb.db.doublelive.OperationSyncLogService;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSyncWriteTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncWriteTask.class);
    private final ByteBuffer physicalPlanBuffer;
    private final SessionPool operationSyncSessionPool;
    private final OperationSyncDDLProtector ddlProtector;
    private final OperationSyncLogService ddlLogService;

    public OperationSyncWriteTask(ByteBuffer physicalPlanBuffer, SessionPool operationSyncSessionPool, OperationSyncDDLProtector ddlProtector, OperationSyncLogService ddlLogService) {
        this.physicalPlanBuffer = physicalPlanBuffer;
        this.operationSyncSessionPool = operationSyncSessionPool;
        this.ddlProtector = ddlProtector;
        this.ddlLogService = ddlLogService;
    }

    @Override
    public void run() {
        if (this.ddlProtector.isAtWork()) {
            this.serializeEPlan();
        } else {
            boolean transmitStatus = false;
            try {
                this.physicalPlanBuffer.position(0);
                transmitStatus = this.operationSyncSessionPool.operationSyncTransmit(this.physicalPlanBuffer);
            }
            catch (IoTDBConnectionException connectionException) {
                LOGGER.warn("OperationSyncWriteTask can't transmit because network failure", (Throwable)connectionException);
            }
            catch (Exception e) {
                LOGGER.error("OperationSyncWriteTask can't transmit", (Throwable)e);
                return;
            }
            if (!transmitStatus) {
                this.serializeEPlan();
            }
        }
    }

    private void serializeEPlan() {
        try {
            this.physicalPlanBuffer.position(this.physicalPlanBuffer.limit());
            this.ddlLogService.acquireLogWriter();
            this.ddlLogService.write(this.physicalPlanBuffer);
        }
        catch (IOException e) {
            LOGGER.error("can't serialize current PhysicalPlan", (Throwable)e);
        }
        finally {
            this.ddlLogService.releaseLogWriter();
        }
    }
}

