/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;

public abstract class AbstractCrossSpaceCompactionTask
extends AbstractCompactionTask {
    List<TsFileResource> selectedSequenceFiles;
    List<TsFileResource> selectedUnsequenceFiles;

    public AbstractCrossSpaceCompactionTask(String fullStorageGroupName, long timePartition, AtomicInteger currentTaskNum, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles, TsFileManager tsFileManager) {
        super(fullStorageGroupName, timePartition, tsFileManager, currentTaskNum);
        this.selectedSequenceFiles = selectedSequenceFiles;
        this.selectedUnsequenceFiles = selectedUnsequenceFiles;
    }

    @Override
    public void setSourceFilesToCompactionCandidate() {
        this.selectedSequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE));
        this.selectedUnsequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE));
    }

    public List<TsFileResource> getSelectedSequenceFiles() {
        return this.selectedSequenceFiles;
    }

    public List<TsFileResource> getSelectedUnsequenceFiles() {
        return this.selectedUnsequenceFiles;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        for (TsFileResource resource : this.selectedSequenceFiles) {
            if (!resource.isCompacting() && resource.isClosed() && resource.getTsFile().exists()) continue;
            return false;
        }
        for (TsFileResource resource : this.selectedUnsequenceFiles) {
            if (!resource.isCompacting() && resource.isClosed() && resource.getTsFile().exists()) continue;
            return false;
        }
        for (TsFileResource resource : this.selectedSequenceFiles) {
            resource.setStatus(TsFileResourceStatus.COMPACTING);
        }
        for (TsFileResource resource : this.selectedUnsequenceFiles) {
            resource.setStatus(TsFileResourceStatus.COMPACTING);
        }
        return true;
    }

    public String toString() {
        return this.fullStorageGroupName + "-" + this.timePartition + " task seq files are " + this.selectedSequenceFiles.toString() + " , unseq files are " + this.selectedUnsequenceFiles.toString();
    }

    @Override
    public void resetCompactionCandidateStatusForAllSourceFiles() {
        this.selectedSequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
        this.selectedUnsequenceFiles.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
    }
}

