/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.Map;
import org.apache.iotdb.db.engine.storagegroup.ILastFlushTimeManager;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceEntry;

public class IDTableFlushTimeManager
implements ILastFlushTimeManager {
    IDTable idTable;

    public IDTableFlushTimeManager(IDTable idTable) {
        this.idTable = idTable;
    }

    @Override
    public void setMultiDeviceLastTime(long timePartitionId, Map<String, Long> lastTimeMap) {
        for (Map.Entry<String, Long> entry : lastTimeMap.entrySet()) {
            this.idTable.getDeviceEntry(entry.getKey()).putLastTimeMap(timePartitionId, entry.getValue());
        }
    }

    @Override
    public void setOneDeviceLastTime(long timePartitionId, String path, long time) {
        this.idTable.getDeviceEntry(path).putLastTimeMap(timePartitionId, time);
    }

    @Override
    public void setMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        for (Map.Entry<String, Long> entry : flushedTimeMap.entrySet()) {
            this.idTable.getDeviceEntry(entry.getKey()).putFlushTimeMap(timePartitionId, entry.getValue());
        }
    }

    @Override
    public void setOneDeviceFlushedTime(long timePartitionId, String path, long time) {
        this.idTable.getDeviceEntry(path).putFlushTimeMap(timePartitionId, time);
    }

    @Override
    public void setMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        for (Map.Entry<String, Long> entry : globalFlushedTimeMap.entrySet()) {
            this.idTable.getDeviceEntry(entry.getKey()).setGlobalFlushTime(entry.getValue());
        }
    }

    @Override
    public void setOneDeviceGlobalFlushedTime(String path, long time) {
        this.idTable.getDeviceEntry(path).setGlobalFlushTime(time);
    }

    @Override
    public void updateLastTime(long timePartitionId, String path, long time) {
        this.idTable.getDeviceEntry(path).updateLastTimeMap(timePartitionId, time);
    }

    @Override
    public void updateFlushedTime(long timePartitionId, String path, long time) {
        this.idTable.getDeviceEntry(path).updateFlushTimeMap(timePartitionId, time);
    }

    @Override
    public void updateGlobalFlushedTime(String path, long time) {
        this.idTable.getDeviceEntry(path).updateGlobalFlushTime(time);
    }

    @Override
    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        throw new UnsupportedOperationException("IDTableFlushTimeManager doesn't support upgrade");
    }

    @Override
    public void ensureLastTimePartition(long timePartitionId) {
    }

    @Override
    public void ensureFlushedTimePartition(long timePartitionId) {
    }

    @Override
    public long ensureFlushedTimePartitionAndInit(long timePartitionId, String path, long initTime) {
        return this.idTable.getDeviceEntry(path).updateFlushTimeMap(timePartitionId, initTime);
    }

    @Override
    public void applyNewlyFlushedTimeToFlushedTime() {
        throw new UnsupportedOperationException("IDTableFlushTimeManager doesn't support upgrade");
    }

    @Override
    public boolean updateLatestFlushTimeToPartition(long partitionId, long latestFlushTime) {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.putLastTimeMap(partitionId, latestFlushTime);
            deviceEntry.putFlushTimeMap(partitionId, latestFlushTime);
            deviceEntry.updateGlobalFlushTime(latestFlushTime);
        }
        return true;
    }

    @Override
    public boolean updateLatestFlushTime(long partitionId) {
        boolean updated = false;
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            Long lastTime = deviceEntry.getLastTime(partitionId);
            if (lastTime == null) continue;
            updated = true;
            deviceEntry.putFlushTimeMap(partitionId, lastTime);
            deviceEntry.updateGlobalFlushTime(lastTime);
        }
        return updated;
    }

    @Override
    public long getFlushedTime(long timePartitionId, String path) {
        return this.idTable.getDeviceEntry(path).getFLushTimeWithDefaultValue(timePartitionId);
    }

    @Override
    public long getLastTime(long timePartitionId, String path) {
        return this.idTable.getDeviceEntry(path).getLastTimeWithDefaultValue(timePartitionId);
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.idTable.getDeviceEntry(path).getGlobalFlushTime();
    }

    @Override
    public void clearLastTime() {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.clearLastTime();
        }
    }

    @Override
    public void clearFlushedTime() {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.clearFlushTime();
        }
    }

    @Override
    public void clearGlobalFlushedTime() {
        for (DeviceEntry deviceEntry : this.idTable.getAllDeviceEntry()) {
            deviceEntry.setGlobalFlushTime(Long.MIN_VALUE);
        }
    }
}

