/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.alertmanager;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.engine.trigger.sink.api.Event;
import org.apache.iotdb.db.engine.trigger.sink.exception.SinkException;

public class AlertManagerEvent
implements Event {
    private static final String PARAMETER_NULL_ERROR_STR = "parameter null error";
    private static final String ALERTNAME_KEY = "alertname";
    private final Map<String, String> labels;
    private final Map<String, String> annotations;
    private static final Pattern pattern = Pattern.compile("\\{\\{\\.\\w+}}");

    public AlertManagerEvent(String alertname) throws SinkException {
        if (alertname == null) {
            throw new SinkException(PARAMETER_NULL_ERROR_STR);
        }
        this.labels = new HashMap<String, String>();
        this.labels.put(ALERTNAME_KEY, alertname);
        this.annotations = null;
    }

    public AlertManagerEvent(String alertname, Map<String, String> extraLabels) throws SinkException {
        if (alertname == null || extraLabels == null) {
            throw new SinkException(PARAMETER_NULL_ERROR_STR);
        }
        this.labels = extraLabels;
        this.labels.put(ALERTNAME_KEY, alertname);
        this.annotations = null;
    }

    public AlertManagerEvent(String alertname, Map<String, String> extraLabels, Map<String, String> annotations) throws SinkException {
        if (alertname == null || extraLabels == null || annotations == null) {
            throw new SinkException(PARAMETER_NULL_ERROR_STR);
        }
        this.labels = extraLabels;
        this.labels.put(ALERTNAME_KEY, alertname);
        this.annotations = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : annotations.entrySet()) {
            this.annotations.put(entry.getKey(), AlertManagerEvent.fillTemplate(this.labels, entry.getValue()));
        }
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String toJsonString() {
        Gson gson = new Gson();
        Type gsonType = new TypeToken<Map>(){}.getType();
        StringBuilder sb = new StringBuilder();
        sb.append("{\"labels\":");
        String labelsString = gson.toJson(this.labels, gsonType);
        sb.append(labelsString);
        if (this.annotations != null) {
            String annotationsString = gson.toJson(this.annotations, gsonType);
            sb.append(",");
            sb.append("\"annotations\":");
            sb.append(annotationsString);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String fillTemplate(Map<String, String> map, String template) {
        if (template == null || map == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(template);
        while (m.find()) {
            String param = m.group();
            String key = param.substring(3, param.length() - 2).trim();
            String value = map.get(key);
            m.appendReplacement(sb, value == null ? "" : value);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

