/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class CreateFunctionPlan
extends PhysicalPlan {
    private String udfName;
    private String className;

    public CreateFunctionPlan() {
        super(Operator.OperatorType.CREATE_FUNCTION);
    }

    public CreateFunctionPlan(String udfName, String className) {
        super(Operator.OperatorType.CREATE_FUNCTION);
        this.udfName = udfName;
        this.className = className;
    }

    public String getUdfName() {
        return this.udfName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<PartialPath> getPaths() {
        return new ArrayList<PartialPath>();
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CREATE_FUNCTION.ordinal());
        this.putString(outputStream, this.udfName);
        this.putString(outputStream, this.className);
        outputStream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.udfName = this.readString(buffer);
        this.className = this.readString(buffer);
        this.index = buffer.getLong();
    }
}

