/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.IFilterOptimizer;

public class DnfFilterOptimizer
implements IFilterOptimizer {
    @Override
    public FilterOperator optimize(FilterOperator filter) throws LogicalOptimizeException {
        return this.getDnf(filter);
    }

    private void dealWithLeftAndRightAndChildren(List<FilterOperator> leftAndChildren, List<FilterOperator> rightAndChildren, List<FilterOperator> newChildrenList) throws LogicalOptimizeException {
        for (FilterOperator leftAndChild : leftAndChildren) {
            for (FilterOperator rightAndChild : rightAndChildren) {
                FilterOperator r = this.mergeToConjunction(leftAndChild.copy(), rightAndChild.copy());
                newChildrenList.add(r);
            }
        }
    }

    private FilterOperator getDnf(FilterOperator filter) throws LogicalOptimizeException {
        if (filter.isLeaf()) {
            return filter;
        }
        List<FilterOperator> childOperators = filter.getChildren();
        if (childOperators.size() != 2) {
            throw new LogicalOptimizeException("node :" + filter.getFilterName() + " has " + childOperators.size() + " children");
        }
        FilterOperator left = this.getDnf(childOperators.get(0));
        FilterOperator right = this.getDnf(childOperators.get(1));
        ArrayList<FilterOperator> newChildrenList = new ArrayList<FilterOperator>();
        switch (filter.getFilterType()) {
            case KW_OR: {
                this.addChildOpInOr(left, newChildrenList);
                this.addChildOpInOr(right, newChildrenList);
                break;
            }
            case KW_AND: {
                if (left.getFilterType() != FilterConstant.FilterType.KW_OR && right.getFilterType() != FilterConstant.FilterType.KW_OR) {
                    this.addChildOpInAnd(left, newChildrenList);
                    this.addChildOpInAnd(right, newChildrenList);
                    break;
                }
                this.dealWithLeftAndRightAndChildren(this.getAndChild(left), this.getAndChild(right), newChildrenList);
                filter.setFilterType(FilterConstant.FilterType.KW_OR);
                break;
            }
            default: {
                throw new LogicalOptimizeException("get DNF failed, this tokenType is:" + (Object)((Object)filter.getFilterType()));
            }
        }
        filter.setChildren(newChildrenList);
        return filter;
    }

    private FilterOperator mergeToConjunction(FilterOperator operator1, FilterOperator operator2) throws LogicalOptimizeException {
        ArrayList<FilterOperator> retChildrenList = new ArrayList<FilterOperator>();
        this.addChildOpInAnd(operator1, retChildrenList);
        this.addChildOpInAnd(operator2, retChildrenList);
        FilterOperator ret = new FilterOperator(FilterConstant.FilterType.KW_AND, false);
        ret.setChildren(retChildrenList);
        return ret;
    }

    private List<FilterOperator> getAndChild(FilterOperator child) {
        if (child.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return child.getChildren();
        }
        ArrayList<FilterOperator> ret = new ArrayList<FilterOperator>();
        ret.add(child);
        return ret;
    }

    private void addChildOpInAnd(FilterOperator operator, List<FilterOperator> newChildrenList) throws LogicalOptimizeException {
        if (operator.isLeaf()) {
            newChildrenList.add(operator);
        } else if (operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            newChildrenList.addAll(operator.getChildren());
        } else {
            throw new LogicalOptimizeException("add all children of an OR operator to newChildrenList in AND");
        }
    }

    private void addChildOpInOr(FilterOperator operator, List<FilterOperator> newChildrenList) {
        if (operator.isLeaf() || operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            newChildrenList.add(operator);
        } else {
            newChildrenList.addAll(operator.getChildren());
        }
    }
}

