/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.executor.fill.ValueFill;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FillQueryExecutor.class);
    protected FillQueryPlan plan;
    protected List<PartialPath> selectedSeries;
    protected List<TSDataType> dataTypes;
    protected Map<TSDataType, IFill> typeIFillMap;
    protected IFill singleFill;
    protected long queryTime;
    protected IFill[] fillExecutors;

    public FillQueryExecutor(FillQueryPlan fillQueryPlan) {
        this.plan = fillQueryPlan;
        this.selectedSeries = this.plan.getDeduplicatedPaths();
        this.singleFill = this.plan.getSingleFill();
        this.typeIFillMap = this.plan.getFillType();
        this.dataTypes = this.plan.getDeduplicatedDataTypes();
        this.queryTime = this.plan.getQueryTime();
        this.fillExecutors = new IFill[this.selectedSeries.size()];
    }

    public QueryDataSet execute(QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        RowRecord record = new RowRecord(this.queryTime);
        Filter timeFilter = this.initFillExecutorsAndContructTimeFilter(context);
        ArrayList<PartialPath> groupedSeries = new ArrayList<PartialPath>();
        for (PartialPath series : this.selectedSeries) {
            MeasurementPath measurementPath = (MeasurementPath)series;
            if (measurementPath.isUnderAlignedEntity()) {
                groupedSeries.add(new AlignedPath(measurementPath));
                continue;
            }
            groupedSeries.add(measurementPath);
        }
        Pair<List<VirtualStorageGroupProcessor>, Map<VirtualStorageGroupProcessor, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(groupedSeries);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        List<TimeValuePair> timeValuePairs = this.getTimeValuePairs(context);
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TimeValuePair timeValuePair;
            TSDataType dataType;
            block14: {
                dataType = this.dataTypes.get(i);
                if (timeValuePairs.get(i) != null) {
                    this.addTimeValueToResult(record, timeValuePairs.get(i), dataType);
                    continue;
                }
                IFill fill = this.fillExecutors[i];
                if (fill instanceof LinearFill && (dataType == TSDataType.VECTOR || dataType == TSDataType.BOOLEAN || dataType == TSDataType.TEXT)) {
                    record.addField(null);
                    logger.info("Linear fill doesn't support the " + i + "-th column in SQL.");
                    continue;
                }
                try {
                    timeValuePair = fill.getFillResult();
                    if (timeValuePair != null || !(fill instanceof ValueFill)) break block14;
                    timeValuePair = ((ValueFill)fill).getSpecifiedFillResult(dataType);
                }
                catch (NumberFormatException | QueryProcessException ignored) {
                    record.addField(null);
                    logger.info("Value fill doesn't support the " + i + "-th column in SQL.");
                    continue;
                }
            }
            if (timeValuePair == null || timeValuePair.getValue() == null) {
                record.addField(null);
                continue;
            }
            this.addTimeValueToResult(record, timeValuePair, dataType);
        }
        SingleDataSet dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        dataSet.setRecord(record);
        return dataSet;
    }

    private void addTimeValueToResult(RowRecord record, TimeValuePair timeValuePair, TSDataType dataType) {
        TsPrimitiveType value = timeValuePair.getValue();
        if (value.getDataType() == TSDataType.VECTOR) {
            record.addField(value.getVector()[0].getValue(), dataType);
        } else {
            record.addField(value.getValue(), dataType);
        }
    }

    private Filter initFillExecutorsAndContructTimeFilter(QueryContext context) throws UnsupportedDataTypeException, QueryProcessException, StorageEngineException {
        long lowerBound = Long.MAX_VALUE;
        long upperBound = Long.MIN_VALUE;
        long defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            long beforeRange;
            IFill fill;
            TSDataType dataType;
            PartialPath path;
            block7: {
                block8: {
                    block6: {
                        path = this.selectedSeries.get(i);
                        dataType = this.dataTypes.get(i);
                        if (this.singleFill == null) break block6;
                        fill = this.singleFill.copy();
                        break block7;
                    }
                    if (this.typeIFillMap.containsKey(dataType)) break block8;
                    switch (dataType) {
                        case INT32: 
                        case INT64: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case TEXT: {
                            fill = new PreviousFill(dataType, this.queryTime, defaultFillInterval);
                            break block7;
                        }
                        default: {
                            throw new UnsupportedDataTypeException("unsupported data type " + dataType);
                        }
                    }
                }
                fill = this.typeIFillMap.get(dataType).copy();
            }
            this.fillExecutors[i] = fill = this.configureFill(fill, path, dataType, this.queryTime, this.plan.getAllMeasurementsInDevice(path.getDevice()), context);
            if (fill instanceof PreviousFill) {
                beforeRange = fill.getBeforeRange();
                lowerBound = Math.min(lowerBound, beforeRange == -1L ? Long.MIN_VALUE : this.queryTime - beforeRange);
                upperBound = Math.max(upperBound, this.queryTime);
                continue;
            }
            if (fill instanceof LinearFill) {
                beforeRange = fill.getBeforeRange();
                long afterRange = fill.getAfterRange();
                lowerBound = Math.min(lowerBound, beforeRange == -1L ? Long.MIN_VALUE : this.queryTime - beforeRange);
                upperBound = Math.max(upperBound, afterRange == -1L ? Long.MAX_VALUE : this.queryTime + afterRange);
                continue;
            }
            if (!(fill instanceof ValueFill)) continue;
            lowerBound = Math.min(lowerBound, this.queryTime);
            upperBound = Math.max(upperBound, this.queryTime);
        }
        return FilterFactory.and((Filter)TimeFilter.gtEq((long)lowerBound), (Filter)TimeFilter.ltEq((long)upperBound));
    }

    protected IFill configureFill(IFill fill, PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) throws QueryProcessException, StorageEngineException {
        fill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
        return fill;
    }

    protected List<TimeValuePair> getTimeValuePairs(QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
        List<ManagedSeriesReader> readers = this.initManagedSeriesReader(context);
        ArrayList<TimeValuePair> ret = new ArrayList<TimeValuePair>(this.selectedSeries.size());
        for (ManagedSeriesReader reader : readers) {
            BatchData batchData;
            if (reader.hasNextBatch() && (batchData = reader.nextBatch()).hasCurrent()) {
                ret.add(new TimeValuePair(batchData.currentTime(), batchData.currentTsPrimitiveType()));
                continue;
            }
            ret.add(null);
        }
        return ret;
    }

    private List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context) throws StorageEngineException, QueryProcessException {
        TimeFilter.TimeEq timeFilter = TimeFilter.eq((long)this.queryTime);
        ArrayList<ManagedSeriesReader> readers = new ArrayList<ManagedSeriesReader>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TSDataType dataType = this.dataTypes.get(i);
            MeasurementPath measurementPath = (MeasurementPath)this.selectedSeries.get(i);
            PartialPath path = measurementPath.isUnderAlignedEntity() ? new AlignedPath(measurementPath) : measurementPath;
            QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, (Filter)timeFilter, this.plan.isAscending());
            timeFilter = queryDataSource.updateFilterUsingTTL((Filter)timeFilter);
            SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, this.plan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, queryDataSource, (Filter)timeFilter, null, null, this.plan.isAscending());
            readers.add(reader);
        }
        return readers;
    }
}

