/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.db.query.udf.builtin.UDTFMath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class UDTFAbs
extends UDTFMath {
    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putInt(time, Math.abs(row.getInt(0)));
                break;
            }
            case INT64: {
                collector.putLong(time, Math.abs(row.getLong(0)));
                break;
            }
            case FLOAT: {
                collector.putFloat(time, Math.abs(row.getFloat(0)));
                break;
            }
            case DOUBLE: {
                collector.putDouble(time, Math.abs(row.getDouble(0)));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, this.dataType, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE);
            }
        }
    }

    @Override
    protected void setTransformer() {
        throw new UnsupportedOperationException("UDTFAbs#setTransformer()");
    }
}

