/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.MemoryStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DefaultStorageProviderTest {
    @After
    public void tearDown() throws Exception {
        System.getProperties().remove("org.apache.james.mime4j.defaultStorageProvider");
        DefaultStorageProvider.reset();
    }

    @Test
    public void testDefaultInstance() throws Exception {
        System.getProperties().remove("org.apache.james.mime4j.defaultStorageProvider");
        DefaultStorageProvider.reset();
        StorageProvider instance = DefaultStorageProvider.getInstance();
        Assert.assertTrue((boolean)(instance instanceof ThresholdStorageProvider));
    }

    @Test
    public void testSetDefaultProperty() throws Exception {
        System.setProperty("org.apache.james.mime4j.defaultStorageProvider", MemoryStorageProvider.class.getName());
        DefaultStorageProvider.reset();
        StorageProvider instance = DefaultStorageProvider.getInstance();
        Assert.assertTrue((boolean)(instance instanceof MemoryStorageProvider));
    }

    @Test
    public void testSetter() throws Exception {
        MemoryStorageProvider instance = new MemoryStorageProvider();
        DefaultStorageProvider.setInstance((StorageProvider)instance);
        Assert.assertSame((Object)instance, (Object)DefaultStorageProvider.getInstance());
    }
}

