/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import org.apache.wiki.event.WikiEvent;

public final class WorkflowEvent
extends WikiEvent {
    private static final long serialVersionUID = 1L;
    public static final int CREATED = 0;
    public static final int STARTED = 10;
    public static final int RUNNING = 20;
    public static final int WAITING = 30;
    public static final int COMPLETED = 40;
    public static final int ABORTED = 50;
    public static final int DQ_ADDITION = 60;
    public static final int DQ_REMOVAL = 70;
    public static final int DQ_DECIDE = 80;
    public static final int DQ_REASSIGN = 90;

    public WorkflowEvent(Object src, int type) {
        super(src, type);
    }

    public WorkflowEvent(Object src, int type, Object ... args) {
        super(src, type, args);
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("WorkflowEvent.");
        msg.append(this.eventName(this.getType()));
        Object obj = this.getSrc();
        msg.append(" [source=").append(obj.toString());
        msg.append("]");
        return msg.toString();
    }

    public String eventName(int type) {
        switch (type) {
            case 0: {
                return "CREATED";
            }
            case 50: {
                return "ABORTED";
            }
            case 40: {
                return "COMPLETED";
            }
            case 20: {
                return "RUNNING";
            }
            case 10: {
                return "STARTED";
            }
            case 30: {
                return "WAITING";
            }
            case 70: {
                return "DQ_REMOVAL";
            }
        }
        return super.eventName();
    }
}

