/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.ImageLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorStateCommonOperations;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;

public class ExternalLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;
    private boolean m_useOutlinkImage = true;

    public ExternalLinkNodePostProcessorState(Context wikiContext, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
        this.m_useOutlinkImage = wikiContext.getBooleanWikiProperty("jspwiki.translatorReader.useOutlinkImage", this.m_useOutlinkImage);
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        if (this.linkOperations.isImageLink(link.getUrl().toString(), this.isImageInlining, this.inlineImagePatterns)) {
            new ImageLinkNodePostProcessorState(this.wikiContext, link.getUrl().toString(), link.hasRef()).process(state, link);
        } else {
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)link.getUrl().toString()));
            NodePostProcessorStateCommonOperations.addOutlinkImage(state, (Node)link, this.wikiContext, this.m_useOutlinkImage);
        }
    }
}

