/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.encode;

import org.apache.juneau.config.encode.ConfigEncoder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;

public final class ConfigXorEncoder
implements ConfigEncoder {
    public static final ConfigXorEncoder INSTANCE = new ConfigXorEncoder();
    private static final String key = System.getProperty("org.apache.juneau.config.XorEncoder.key", "nuy7og796Vh6G9O6bG230SHK0cc8QYkH");

    @Override
    public String encode(String fieldName, String in) {
        byte[] b = in.getBytes(IOUtils.UTF8);
        for (int i = 0; i < b.length; ++i) {
            int j = i % key.length();
            b[i] = (byte)(b[i] ^ key.charAt(j));
        }
        return '{' + StringUtils.base64Encode(b) + '}';
    }

    @Override
    public String decode(String fieldName, String in) {
        if (!this.isEncoded(in)) {
            return in;
        }
        in = in.substring(1, in.length() - 1);
        byte[] b = StringUtils.base64Decode(in);
        for (int i = 0; i < b.length; ++i) {
            int j = i % key.length();
            b[i] = (byte)(b[i] ^ key.charAt(j));
        }
        return new String(b, IOUtils.UTF8);
    }

    @Override
    public boolean isEncoded(String in) {
        return in != null && in.length() > 1 && in.charAt(0) == '{' && in.charAt(in.length() - 1) == '}';
    }
}

