/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.List;
import org.apache.juneau.collections.AList;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;

public class EncoderGroupBuilder {
    private final AList<Encoder> encoders = AList.of();

    public EncoderGroupBuilder() {
    }

    public EncoderGroupBuilder(EncoderGroup copyFrom) {
        this.encoders.arev(copyFrom.getEncoders());
    }

    public EncoderGroupBuilder append(Class<?> ... e) {
        for (int i = e.length - 1; i >= 0; --i) {
            this.encoders.add(ClassUtils.castOrCreate(Encoder.class, e[i]));
        }
        return this;
    }

    public EncoderGroupBuilder append(Encoder ... e) {
        this.encoders.arev((Encoder[])e);
        return this;
    }

    public EncoderGroupBuilder append(List<Encoder> e) {
        this.encoders.arev(e);
        return this;
    }

    public EncoderGroupBuilder append(EncoderGroup eg) {
        this.append(eg.getEncoders());
        return this;
    }

    public EncoderGroup build() {
        ArrayList<Encoder> l = new ArrayList<Encoder>();
        for (Object e : this.encoders) {
            l.add(ClassUtils.castOrCreate(Encoder.class, e));
        }
        return new EncoderGroup(ArrayUtils.toReverseArray(Encoder.class, l));
    }
}

