/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestRequest;

public class RequestPath
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private HttpPartParserSession parser;

    RequestPath(RestCall call) {
        super(String.CASE_INSENSITIVE_ORDER);
        this.req = call.getRestRequest();
        this.putAll(call.getPathVars());
    }

    RequestPath parser(HttpPartParserSession parser) {
        this.parser = parser;
        return this;
    }

    RequestPath remainder(String remainder) {
        this.put("/**", remainder);
        this.put("/*", StringUtils.urlDecode(remainder));
        return this;
    }

    @Override
    public void put(String name, Object value) {
        super.put(name, value.toString());
    }

    public String getString(String name) throws BadRequest, InternalServerError {
        return this.getInner(this.parser, null, name, null, this.req.getBeanSession().string());
    }

    public int getInt(String name) throws BadRequest, InternalServerError {
        return this.getInner(this.parser, null, name, null, this.getClassMeta(Integer.TYPE));
    }

    public boolean getBoolean(String name) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(Boolean.TYPE));
    }

    public <T> T get(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParserSession parser, HttpPartSchema schema, String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type));
    }

    public <T> T get(String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type, args));
    }

    public <T> T get(HttpPartParserSession parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type, args));
    }

    private <T> T getInner(HttpPartParserSession parser, HttpPartSchema schema, String name, T def, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        if (parser == null) {
            parser = this.req.getPartParser();
        }
        try {
            if (cm.isMapOrBean() && StringUtils.isOneOf(name, "*", "")) {
                OMap m = new OMap();
                for (Map.Entry e : this.entrySet()) {
                    String k = (String)e.getKey();
                    HttpPartSchema pschema = schema == null ? null : schema.getProperty(k);
                    ClassMeta<?> cm2 = cm.getValueType();
                    m.put(k, this.getInner(parser, pschema, k, null, cm2));
                }
                return this.req.getBeanSession().convertToType((Object)m, cm);
            }
            T t = this.parse(parser, schema, (String)this.get(name), cm);
            return t == null ? def : t;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on path parameter ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse path parameter ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse path parameter ''{0}''.", name);
        }
    }

    private <T> T parse(HttpPartParserSession parser, HttpPartSchema schema, String val, ClassMeta<T> cm) throws SchemaValidationException, ParseException {
        if (parser == null) {
            parser = this.parser;
        }
        return parser.parse(HttpPartType.PATH, schema, val, cm);
    }

    public String getRemainder() {
        return (String)this.get("/*");
    }

    public String getRemainderUndecoded() {
        return (String)this.get("/**");
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }
}

