/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.SwaggerException;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.ResourceSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.AnnotationUtils;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.svl.VarResolverSession;

final class SwaggerGenerator {
    private final VarResolverSession vr;
    private final Locale locale;
    private final RestContext context;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Class<?> c;
    private final Object resource;
    private final Messages mb;

    public SwaggerGenerator(RestContext context, VarResolverSession vr, Locale locale) {
        this.vr = vr;
        this.locale = locale;
        this.context = context;
        this.js = context.getJsonSchemaGenerator().createSession();
        this.c = context.getResource().getClass();
        this.resource = context.getResource();
        this.mb = context.getMessages().forLocale(locale);
    }

    /*
     * Could not resolve type clashes
     */
    public Swagger getSwagger() throws Exception {
        String s;
        Object info;
        ResourceSwagger r;
        OMap sInfo;
        ClassInfo rci = ClassInfo.of(this.resource).resolved();
        rci.getSimpleName();
        OMap omSwagger = this.context.getClasspathResource(OMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        if (omSwagger == null) {
            omSwagger = this.context.getClasspathResource(OMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        }
        if (omSwagger == null) {
            omSwagger = new OMap();
        }
        for (Annotation rr : rci.getAnnotations(RestResource.class)) {
            sInfo = omSwagger.getMap("info", true);
            sInfo.ase("title", this.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()})));
            sInfo.ase("description", this.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()})));
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getMap("info", true);
                ((OMap)info).ase("title", this.resolve(new String[][]{r.title()})).ase("description", this.resolve(new String[][]{r.description()})).ase("version", this.resolve(r.version())).ase("termsOfService", this.resolve(new String[][]{r.termsOfService()})).ase("contact", this.merge(((OMap)info).getMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c))).ase("license", this.merge(((OMap)info).getMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.ase("externalDocs", this.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c))).ase("tags", this.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        for (Annotation rr : rci.getAnnotations(Rest.class)) {
            sInfo = omSwagger.getMap("info", true);
            sInfo.ase("title", this.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()}))).ase("description", this.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()})));
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getMap("info", true);
                ((OMap)info).ase("title", this.resolve(new String[][]{r.title()})).ase("description", this.resolve(new String[][]{r.description()})).ase("version", this.resolve(r.version())).ase("termsOfService", this.resolve(new String[][]{r.termsOfService()})).ase("contact", this.merge(((OMap)info).getMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c))).ase("license", this.merge(((OMap)info).getMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.ase("externalDocs", this.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c))).ase("tags", this.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        omSwagger.ase("externalDocs", this.parseMap(this.mb.findFirstString("externalDocs"), "Messages/externalDocs on class {0}", this.c));
        OMap info2 = omSwagger.getMap("info", true);
        info2.ase("title", this.resolve(this.mb.findFirstString("title"))).ase("description", this.resolve(this.mb.findFirstString("description"))).ase("version", this.resolve(this.mb.findFirstString("version"))).ase("termsOfService", this.resolve(this.mb.findFirstString("termsOfService"))).ase("contact", this.parseMap(this.mb.findFirstString("contact"), "Messages/contact on class {0}", this.c)).ase("license", this.parseMap(this.mb.findFirstString("license"), "Messages/license on class {0}", this.c));
        if (info2.isEmpty()) {
            omSwagger.remove("info");
        }
        OList produces = omSwagger.getList("produces", true);
        OList consumes = omSwagger.getList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<Object, Object> tagMap = new LinkedHashMap<Object, Object>();
        if (omSwagger.containsKey("tags")) {
            for (Object om : omSwagger.getList("tags").elements(OMap.class)) {
                String name = ((OMap)om).getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if ((s = this.mb.findFirstString("tags")) != null) {
            for (Object m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(OMap.class)) {
                String name = ((OMap)m).getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", new Object[]{this.c});
                }
                if (tagMap.containsKey(name)) {
                    ((OMap)tagMap.get(name)).putAll(m);
                    continue;
                }
                tagMap.put(name, m);
            }
        }
        OMap definitions = omSwagger.getMap("definitions", true);
        for (String defId : definitions.keySet()) {
            this.js.addBeanDef(defId, new OMap((Map<?, ?>)definitions.getMap(defId)));
        }
        for (RestMethodContext sm : this.context.getMethodContexts()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            Iterator<Comparable<Integer>> mpi;
            BeanSession bs = sm.createBeanSession();
            Method m = sm.method;
            MethodInfo mi = MethodInfo.of(m);
            RestMethod rm = mi.getLastAnnotation(RestMethod.class);
            String mn = m.getName();
            OMap op = this.getOperation(omSwagger, sm.getPathPattern(), sm.getHttpMethod().toLowerCase());
            MethodSwagger ms = rm.swagger();
            op.appendAll((Map)this.parseMap(ms.value(), "@MethodSwagger(value) on class {0} method {1}", this.c, m));
            op.ase("operationId", this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            op.ase("summary", this.firstNonEmpty(this.resolve(new String[][]{ms.summary()}), this.resolve(this.mb.findFirstString(mn + ".summary")), op.getString("summary"), this.resolve(rm.summary())));
            op.ase("description", this.firstNonEmpty(this.resolve(new String[][]{ms.description()}), this.resolve(this.mb.findFirstString(mn + ".description")), op.getString("description"), this.resolve(new String[][]{rm.description()})));
            op.ase("deprecated", this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null));
            op.ase("tags", this.merge(this.parseListOrCdl(this.mb.findFirstString(mn + ".tags"), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@MethodSwagger(tags) on class {0} method {1}", this.c, m)));
            op.ase("schemes", this.merge(this.parseListOrCdl(this.mb.findFirstString(mn + ".schemes"), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@MethodSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.ase("consumes", this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(mn + ".consumes"), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@MethodSwagger(consumes) on class {0} method {1}", this.c, m)));
            op.ase("produces", this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(mn + ".produces"), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@MethodSwagger(produces) on class {0} method {1}", this.c, m)));
            op.ase("parameters", this.merge(this.parseList(this.mb.findFirstString(mn + ".parameters"), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@MethodSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.ase("responses", this.merge(this.parseMap(this.mb.findFirstString(mn + ".responses"), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@MethodSwagger(responses) on class {0} method {1}", this.c, m)));
            op.ase("externalDocs", this.merge(op.getMap("externalDocs"), this.parseMap(this.mb.findFirstString(mn + ".externalDocs"), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@MethodSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey("tags")) {
                for (Object tag : op.getList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag)) continue;
                    tagMap.put(tag, OMap.of(new Object[]{"name", tag}));
                }
            }
            OMap paramMap = new OMap();
            if (op.containsKey("parameters")) {
                Object tag;
                tag = op.getList("parameters").elements(OMap.class).iterator();
                while (tag.hasNext()) {
                    OMap param = (OMap)tag.next();
                    paramMap.put(param.getString("in") + '.' + ("body".equals(param.getString("in")) ? "body" : param.getString("name")), param);
                }
            }
            for (RestMethodParam mp : sm.methodParams) {
                RestParamType in = mp.getParamType();
                mpi = mp.getMethodParamInfo();
                if (!in.isAny(RestParamType.BODY, RestParamType.QUERY, RestParamType.FORM_DATA, RestParamType.HEADER, RestParamType.PATH)) continue;
                String key = in.toString() + '.' + (in == RestParamType.BODY ? "body" : mp.getName());
                OMap param = paramMap.getMap(key, true);
                param.append("in", (Object)in);
                if (in != RestParamType.BODY) {
                    param.append("name", mp.name);
                }
                try {
                    if (mpi != null) {
                        if (in == RestParamType.BODY) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotations(Body.class)) {
                                this.merge(param, (Body)a);
                            }
                        } else if (in == RestParamType.QUERY) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotations(Query.class)) {
                                this.merge(param, (Query)a);
                            }
                        } else if (in == RestParamType.FORM_DATA) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotations(FormData.class)) {
                                this.merge(param, (FormData)a);
                            }
                        } else if (in == RestParamType.HEADER) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotations(Header.class)) {
                                this.merge(param, (Header)a);
                            }
                        } else if (in == RestParamType.PATH) {
                            for (Annotation a : ((ParamInfo)((Object)mpi)).getAnnotations(Path.class)) {
                                this.merge(param, (Path)a);
                            }
                        }
                    }
                }
                catch (ParseException e) {
                    throw new SwaggerException(e, "Malformed swagger JSON object encountered in {0} class {1} method parameter {2}", new Object[]{in, this.c, mpi});
                }
                if (!(in != RestParamType.BODY && in != RestParamType.PATH || param.containsKeyNotEmpty("required"))) {
                    param.put("required", true);
                }
                if (in == RestParamType.BODY) {
                    param.ase("schema", this.getSchema(param.getMap("schema"), mp.getType(), bs));
                    this.addBodyExamples(sm, param, false, mp.getType());
                    continue;
                }
                this.mergePartSchema(param, this.getSchema(param.getMap("schema"), mp.getType(), bs));
                this.addParamExample(sm, param, in, mp.getType());
            }
            if (!paramMap.isEmpty()) {
                op.put("parameters", paramMap.values());
            }
            OMap responses = op.getMap("responses", true);
            for (ClassInfo eci : mi.getExceptionTypes()) {
                if (!eci.hasAnnotation(Response.class)) continue;
                Iterator<MethodInfo> la = eci.getAnnotations(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 500);
                mpi = la.iterator();
                while (mpi.hasNext()) {
                    Response a = (Response)mpi.next();
                    for (Integer code : codes) {
                        OMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (om.containsKey("schema")) continue;
                        om.ase("schema", this.getSchema(om.getMap("schema"), eci.inner(), bs));
                    }
                }
                for (MethodInfo ecmi : eci.getAllMethodsParentFirst()) {
                    ResponseHeader a = ecmi.getLastAnnotation(ResponseHeader.class);
                    if (a == null) {
                        a = ecmi.getResolvedReturnType().getLastAnnotation(ResponseHeader.class);
                    }
                    if (a == null || this.isMulti(a)) continue;
                    String ha = a.name();
                    for (Integer code : codes) {
                        OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                        this.merge(header, a);
                        this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getResolvedReturnType().hasAnnotation(Response.class)) {
                List<Response> la = mi.getAnnotations(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        OMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (!om.containsKey("schema")) {
                            om.ase("schema", this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs));
                        }
                        this.addBodyExamples(sm, om, true, m.getGenericReturnType());
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    for (MethodInfo ecmi : mi.getReturnType().getAllMethodsParentFirst()) {
                        if (!ecmi.hasAnnotation(ResponseHeader.class)) continue;
                        ResponseHeader a = ecmi.getLastAnnotation(ResponseHeader.class);
                        String ha = a.name();
                        if (this.isMulti(a)) continue;
                        for (Integer code : codes) {
                            OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                OMap om = responses.getMap("200", true);
                if (!om.containsKey("schema")) {
                    om.ase("schema", this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs));
                }
                this.addBodyExamples(sm, om, true, m.getGenericReturnType());
            }
            for (RestMethodParam mp : sm.methodParams) {
                Set<Integer> codes;
                List<Annotation> la;
                RestParamType in = mp.getParamType();
                ParamInfo mpi2 = mp.getMethodParamInfo();
                if (in == RestParamType.RESPONSE_HEADER) {
                    la = mpi2.getAnnotations(ResponseHeader.class);
                    codes = SwaggerGenerator.getCodes2(la, 200);
                    for (Annotation a : la) {
                        if (this.isMulti((ResponseHeader)a)) continue;
                        for (Integer code : codes) {
                            OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(mp.name, true);
                            this.merge(header, (ResponseHeader)a);
                            this.mergePartSchema(header, this.getSchema(header, Value.getParameterType(mp.type), bs));
                        }
                    }
                    continue;
                }
                if (in != RestParamType.RESPONSE) continue;
                la = mpi2.getAnnotations(Response.class);
                codes = SwaggerGenerator.getCodes(la, 200);
                for (Annotation a : la) {
                    for (Integer code : codes) {
                        OMap response = responses.getMap(String.valueOf(code), true);
                        this.merge(response, (Response)a);
                    }
                }
                Type type = Value.getParameterType(mp.type);
                if (type == null) continue;
                for (String code : responses.keySet()) {
                    OMap om = responses.getMap(code);
                    if (om.containsKey("schema")) continue;
                    om.ase("schema", this.getSchema(om.getMap("schema"), type, bs));
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                OMap val = responses.getMap(key);
                if (!StringUtils.isDecimal(key)) continue;
                val.appendIf(false, true, true, "description", RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove("responses");
            } else {
                op.put("responses", new TreeMap<String, Object>(responses));
            }
            if (!op.containsKey("consumes") && !(mConsumes = sm.supportedContentTypes).equals(consumes)) {
                op.put("consumes", mConsumes);
            }
            if (op.containsKey("produces") || (mProduces = sm.supportedAcceptTypes).equals(produces)) continue;
            op.put("produces", mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry<String, OMap> e : this.js.getBeanDefs().entrySet()) {
                definitions.put(e.getKey(), this.fixSwaggerExtensions(e.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove("definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put("tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove("consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove("produces");
        }
        try {
            String swaggerJson = omSwagger.toString(SimpleJsonSerializer.DEFAULT_READABLE);
            return this.jp.parse(swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new RestServletException(e, "Error detected in swagger.", new Object[0]);
        }
    }

    private boolean isMulti(ResponseHeader h) {
        return "*".equals(h.name()) || "*".equals(h.value());
    }

    private OMap resolve(OMap om) throws ParseException {
        OMap om2 = null;
        if (om.containsKey("_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove("_value"));
        } else {
            om2 = new OMap();
        }
        for (Map.Entry<String, Object> e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof OMap) {
                val = this.resolve((OMap)val);
            } else if (val instanceof OList) {
                val = this.resolve((OList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private OList resolve(OList om) throws ParseException {
        OList ol2 = new OList();
        for (Object val : om) {
            if (val instanceof OMap) {
                val = this.resolve((OMap)val);
            } else if (val instanceof OList) {
                val = this.resolve((OList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ... s) {
        for (String[] ss : s) {
            if (ss.length == 0) continue;
            return this.resolve(SwaggerGenerator.joinnl(new String[][]{ss}));
        }
        return null;
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private OMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return OMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private OMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private OMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SwaggerGenerator.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s = this.resolve(s))) {
                return OMap.of(new Object[]{"ignore", true});
            }
            if (!StringUtils.isJsonObject(s, true)) {
                s = "{" + s + "}";
            }
            return OMap.ofJson(s);
        }
        if (o instanceof OMap) {
            return (OMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected OMap or String.", new Object[]{o.getClass().getName()});
    }

    private OList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if (!StringUtils.isJsonArray(s = this.resolve(s), true)) {
                s = "[" + s + "]";
            }
            return OList.ofJson(s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private OList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return StringUtils.parseListOrCdl(s);
        }
        catch (ParseException e) {
            throw new SwaggerException(e, "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private OMap newMap(OMap om, String[] value, String location, Object ... locationArgs) throws ParseException {
        if (value.length == 0) {
            return om == null ? new OMap() : om;
        }
        OMap om2 = this.parseMap(SwaggerGenerator.joinnl(new String[][]{value}), location, locationArgs);
        if (om == null) {
            return om2;
        }
        return om.appendAll((Map)om2);
    }

    private OMap merge(OMap ... maps) {
        OMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new OMap();
            }
            m.putAll(maps[i]);
        }
        return m;
    }

    private OList merge(OList ... lists) {
        OList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new OList();
            }
            l.addAll(lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        return ObjectUtils.firstNonEmpty(t);
    }

    private OMap toMap(ExternalDocs a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("description", this.resolve(SwaggerGenerator.joinnl(new String[][]{a.description()}))).ase("url", this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(Contact a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("name", this.resolve(a.name())).ase("url", this.resolve(a.url())).ase("email", this.resolve(a.email()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(License a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("name", this.resolve(a.name())).ase("url", this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(Tag a, String location, Object ... locationArgs) throws ParseException {
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs);
        om.ase("name", this.resolve(a.name())).ase("description", this.resolve(SwaggerGenerator.joinnl(new String[][]{a.description()}))).asn("externalDocs", this.merge(om.getMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OList toList(Tag[] aa, String location, Object ... locationArgs) throws ParseException {
        if (aa.length == 0) {
            return null;
        }
        OList ol = new OList();
        for (Tag a : aa) {
            ol.add(this.toMap(a, location, locationArgs));
        }
        return SwaggerGenerator.nullIfEmpty(ol);
    }

    private OMap getSchema(OMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return null;
        }
        schema = SwaggerGenerator.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", false).booleanValue()) {
            return null;
        }
        if (schema.containsKey("type") || schema.containsKey("$ref")) {
            return schema;
        }
        OMap om = this.fixSwaggerExtensions((OMap)schema.appendAll((Map)this.js.getSchema(cm)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap fixSwaggerExtensions(OMap om) {
        om.asn("discriminator", om.remove("x-discriminator")).asn("readOnly", om.remove("x-readOnly")).asn("xml", om.remove("x-xml")).asn("externalDocs", om.remove("x-externalDocs")).asn("example", om.remove("x-example"));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private void addBodyExamples(RestMethodContext sm, OMap piri, boolean response, Type type) throws Exception {
        OMap schema;
        String sex = piri.getString("x-example");
        if (sex == null && (schema = this.resolveRef(piri.getMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("x-example"));
        }
        if (StringUtils.isEmpty(sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson(sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate(sex);
            }
        }
        String examplesKey = response ? "examples" : "x-examples";
        OMap examples = piri.getMap(examplesKey);
        if (examples == null) {
            examples = new OMap();
        }
        List<MediaType> mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            SerializerSessionArgs args = SerializerSessionArgs.create().locale(this.locale).mediaType(mt).useWhitespace(true);
            try {
                String eVal = s2.createSession(args).serializeToString(example);
                examples.put(s2.getPrimaryMediaType().toString(), eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + mt + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put(examplesKey, examples);
        }
    }

    private void addParamExample(RestMethodContext sm, OMap piri, RestParamType in, Type type) throws Exception {
        String s = piri.getString("x-example");
        if (StringUtils.isEmpty(s)) {
            return;
        }
        OMap examples = piri.getMap("x-examples");
        if (examples == null) {
            examples = new OMap();
        }
        String paramName = piri.getString("name");
        if (in == RestParamType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax(paramName) + "=" + StringUtils.urlEncodeLax(s);
        } else if (in == RestParamType.FORM_DATA) {
            s = paramName + "=" + s;
        } else if (in == RestParamType.HEADER) {
            s = paramName + ": " + s;
        } else if (in == RestParamType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax(s));
        }
        examples.put("example", s);
        if (!examples.isEmpty()) {
            piri.put("x-examples", examples);
        }
    }

    private OMap resolveRef(OMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey("$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private OMap getOperation(OMap om, String path, String httpMethod) {
        if (!om.containsKey("paths")) {
            om.put("paths", new OMap());
        }
        if (!(om = om.getMap("paths")).containsKey(path)) {
            om.put(path, new OMap());
        }
        if (!(om = om.getMap(path)).containsKey(httpMethod)) {
            om.put(httpMethod, new OMap());
        }
        return om.getMap(httpMethod);
    }

    private static OMap newMap(OMap om) {
        if (om == null) {
            return new OMap();
        }
        return om.modifiable();
    }

    private OMap merge(OMap om, Body a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.ase("description", this.resolve(a.description(), a.d())).ase("x-example", this.resolve(a.example(), a.ex())).ase("x-examples", this.parseMap(a.examples()), this.parseMap(a.exs())).asf("required", a.required() || a.r()).ase("schema", this.merge(om.getMap("schema"), a.schema()));
    }

    private OMap merge(OMap om, Query a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.asf("allowEmptyValue", a.allowEmptyValue() || a.aev()).ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("description", this.resolve(a.description(), a.d())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(a.example(), a.ex())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).asf("required", a.required() || a.r()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, FormData a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.asf("allowEmptyValue", a.allowEmptyValue() || a.aev()).ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("description", this.resolve(a.description(), a.d())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(a.example(), a.ex())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).asf("required", a.required()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Header a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("description", this.resolve(a.description(), a.d())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(a.example(), a.ex())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).asf("required", a.required() || a.r()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Path a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("description", this.resolve(a.description(), a.d())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(a.example(), a.ex())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Schema a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.ase("additionalProperties", this.toOMap(a.additionalProperties())).ase("allOf", SwaggerGenerator.joinnl(new String[][]{a.allOf()})).ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("discriminator", a.discriminator()).ase("description", this.resolve(new String[][]{a.description()}), this.resolve(new String[][]{a.d()})).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(new String[][]{a.example()}), this.resolve(new String[][]{a.ex()})).ase("examples", this.parseMap(a.examples()), this.parseMap(a.exs())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("externalDocs", this.merge(om.getMap("externalDocs"), a.externalDocs())).ase("format", a.format(), a.f()).ase("ignore", a.ignore() ? "true" : null).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).asmo("maxProperties", a.maxProperties(), a.maxp()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).asmo("minProperties", a.minProperties(), a.minp()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("properties", this.toOMap(a.properties())).asf("readOnly", a.readOnly() || a.ro()).asf("required", a.required() || a.r()).ase("title", a.title()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("xml", SwaggerGenerator.joinnl(new String[][]{a.xml()})).ase("$ref", a.$ref());
    }

    private OMap merge(OMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.ase("description", this.resolve(new String[][]{a.description()})).ase("url", a.url());
    }

    private OMap merge(OMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("format", a.format(), a.f()).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("type", a.type(), a.t()).ase("$ref", a.$ref());
    }

    private OMap merge(OMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll(this.parseMap(a.value()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.toOMap(a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("$ref", a.$ref());
    }

    private OMap merge(OMap om, Response a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.ase("description", this.resolve(a.description(), a.d())).ase("x-example", this.resolve(a.example(), a.ex())).ase("examples", this.parseMap(a.examples()), this.parseMap(a.exs())).ase("headers", this.merge(om.getMap("headers"), a.headers())).ase("schema", this.merge(om.getMap("schema"), a.schema()));
    }

    private OMap merge(OMap om, ResponseHeader[] a) throws ParseException {
        if (a.length == 0) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        for (ResponseHeader aa : a) {
            String name = StringUtils.firstNonEmpty(aa.name(), aa.value());
            if (StringUtils.isEmpty(name)) {
                throw new RuntimeException("@ResponseHeader used without name or value.");
            }
            om.getMap(name, true).putAll(this.merge(null, aa));
        }
        return om;
    }

    private OMap merge(OMap om, ResponseHeader a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll(this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SwaggerGenerator.joinnl(a._default(), a.df())).ase("description", this.resolve(a.description(), a.d())).ase("enum", this.toSet(a._enum()), this.toSet(a.e())).ase("x-example", this.resolve(a.example(), a.ex())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", this.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("$ref", a.$ref());
    }

    private OMap mergePartSchema(OMap param, OMap schema) {
        if (schema != null) {
            param.appendIf(false, true, true, "collectionFormat", schema.remove("collectionFormat")).appendIf(false, true, true, "default", schema.remove("default")).appendIf(false, true, true, "description", schema.remove("enum")).appendIf(false, true, true, "enum", schema.remove("enum")).appendIf(false, true, true, "x-example", schema.remove("x-example")).appendIf(false, true, true, "exclusiveMaximum", schema.remove("exclusiveMaximum")).appendIf(false, true, true, "exclusiveMinimum", schema.remove("exclusiveMinimum")).appendIf(false, true, true, "format", schema.remove("format")).appendIf(false, true, true, "items", schema.remove("items")).appendIf(false, true, true, "maximum", schema.remove("maximum")).appendIf(false, true, true, "maxItems", schema.remove("maxItems")).appendIf(false, true, true, "maxLength", schema.remove("maxLength")).appendIf(false, true, true, "minimum", schema.remove("minimum")).appendIf(false, true, true, "minItems", schema.remove("minItems")).appendIf(false, true, true, "minLength", schema.remove("minLength")).appendIf(false, true, true, "multipleOf", schema.remove("multipleOf")).appendIf(false, true, true, "pattern", schema.remove("pattern")).appendIf(false, true, true, "required", schema.remove("required")).appendIf(false, true, true, "type", schema.remove("type")).appendIf(false, true, true, "uniqueItems", schema.remove("uniqueItems"));
            if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                param.put("schema", schema);
            }
        }
        return param;
    }

    private OMap toOMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject(s, true)) {
            s = "{" + s + "}";
        }
        s = this.resolve(s);
        return OMap.ofJson(s);
    }

    private Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        s = this.resolve(s);
        ASet<String> set = ASet.of(new String[0]);
        for (Object o : StringUtils.parseListOrCdl(s)) {
            set.add(o.toString());
        }
        return set;
    }

    static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl(objectArray).trim();
        }
        return "";
    }

    private static Set<Integer> getCodes(List<Response> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (Response a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static Set<Integer> getCodes2(List<ResponseHeader> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (ResponseHeader a : la) {
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static OMap nullIfEmpty(OMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static OList nullIfEmpty(OList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

