/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public final class AMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;

    public AMap() {
    }

    public AMap(Map<K, V> copy) {
        super(copy == null ? Collections.emptyMap() : copy);
    }

    public static <K, V> AMap<K, V> of() {
        return new AMap<K, V>();
    }

    public static <K, V> AMap<K, V> of(K key, V value) {
        return new AMap<K, V>().a(key, value);
    }

    public static <K, V> AMap<K, V> ofPairs(Object ... parameters) {
        AMap<Object, Object> m = AMap.of();
        if (parameters.length % 2 != 0) {
            throw new BasicRuntimeException("Odd number of parameters passed into AMap.ofPairs()", new Object[0]);
        }
        for (int i = 0; i < parameters.length; i += 2) {
            m.put(parameters[i], parameters[i + 1]);
        }
        return m;
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2) {
        return AMap.of(k1, v1).a(k2, v2);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3).a(k4, v4);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3).a(k4, v4).a(k5, v5);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3).a(k4, v4).a(k5, v5).a(k6, v6);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3).a(k4, v4).a(k5, v5).a(k6, v6).a(k7, v7);
    }

    public static <K, V> AMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return AMap.of(k1, v1).a(k2, v2).a(k3, v3).a(k4, v4).a(k5, v5).a(k6, v6).a(k7, v7).a(k8, v8);
    }

    public static <K, V> AMap<K, V> of(Map<K, V> copy) {
        return new AMap<K, V>(copy);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> copy) {
        if (copy == null || copy.isEmpty()) {
            return Collections.emptyMap();
        }
        return new AMap<K, V>(copy).unmodifiable();
    }

    public static <K, V> AMap<K, V> nullable(Map<K, V> c) {
        return c == null ? null : AMap.of(c);
    }

    public AMap<K, V> a(K k, V v) {
        this.put(k, v);
        return this;
    }

    public AMap<K, V> aa(Map<K, V> c) {
        super.putAll(c);
        return this;
    }

    public Map<K, V> unmodifiable() {
        return this.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this);
    }

    public String asString(WriterSerializer ws) {
        return ws.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public String toString() {
        return this.asString(SimpleJsonSerializer.DEFAULT);
    }
}

