/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.openapi3.MediaType;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="description,content,required,*")
@FluentSetters
public class RequestBodyInfo
extends OpenApiElement {
    private String description;
    private Map<String, MediaType> content;
    private Boolean required;

    public RequestBodyInfo() {
    }

    public RequestBodyInfo(RequestBodyInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.required = copyFrom.required;
        if (copyFrom.content == null) {
            this.content = null;
        } else {
            this.content = new LinkedHashMap<String, MediaType>();
            for (Map.Entry<String, MediaType> e : copyFrom.content.entrySet()) {
                this.content.put(e.getKey(), e.getValue().copy());
            }
        }
    }

    public RequestBodyInfo copy() {
        return new RequestBodyInfo(this);
    }

    @Override
    protected RequestBodyInfo strict() {
        super.strict();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RequestBodyInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Map<String, MediaType> getContent() {
        return this.content;
    }

    public RequestBodyInfo setContent(Map<String, MediaType> value) {
        this.content = CollectionUtils.copyOf(value);
        return this;
    }

    public RequestBodyInfo addContent(String key, MediaType value) {
        this.content = CollectionUtils.mapBuilder(this.content).sparse().add(key, value).build();
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public RequestBodyInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "content": {
                return ConverterUtils.toType(this.getContent(), type);
            }
            case "required": {
                return ConverterUtils.toType(this.getRequired(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public RequestBodyInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "content": {
                return this.setContent(CollectionUtils.mapBuilder(String.class, MediaType.class, new Type[0]).sparse().addAny(value).build());
            }
            case "required": {
                return this.setRequired(ConverterUtils.toBoolean(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.description != null, "description").addIf(this.content != null, "content").addIf(this.required != null, "required").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

