/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;

public class DelegateMap<T extends Map>
extends JsonMap
implements Delegate<T> {
    private static final long serialVersionUID = 1L;
    private transient ClassMeta<T> classMeta;

    public DelegateMap(T m, BeanSession session) {
        this.classMeta = session.getClassMetaForObject(m);
        m.forEach((k, v) -> this.put(StringUtils.stringify(k), v));
    }

    @Override
    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public DelegateMap<T> filterKeys(List<String> keys) {
        JsonMap m = new JsonMap();
        keys.forEach((? super T k) -> {
            if (this.containsKey(k)) {
                m.put((String)k, this.get(k));
            }
        });
        this.clear();
        this.putAll(m);
        return this;
    }
}

