/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;

public class JsonList
extends LinkedList<Object> {
    private static final long serialVersionUID = 1L;
    transient BeanSession session = null;
    private transient ObjectRest objectRest;
    public static final JsonList EMPTY_LIST = new JsonList(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public ListIterator<Object> listIterator(int location) {
            return Collections.emptyList().listIterator(location);
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public List<Object> subList(int start, int end) {
            return Collections.emptyList().subList(start, end);
        }
    };

    public static JsonList ofJsonOrCdl(String s) throws ParseException {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        if (!StringUtils.isJsonArray((Object)s, (boolean)true)) {
            return new JsonList(StringUtils.split((String)s.trim(), (char)','));
        }
        return new JsonList(s);
    }

    public JsonList() {
    }

    public JsonList(BeanSession session) {
        this.session = session;
    }

    public JsonList(Collection<?> copyFrom) {
        super(copyFrom);
    }

    public JsonList(CharSequence json) throws ParseException {
        this(json, (Parser)JsonParser.DEFAULT);
    }

    public JsonList(CharSequence in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (in != null) {
            p.parseIntoCollection(in, this, this.bs().object());
        }
    }

    public JsonList(Reader json) throws ParseException {
        this.parse(json, JsonParser.DEFAULT);
    }

    public JsonList(Reader in, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT_SESSION : p.getBeanContext().getSession());
        this.parse(in, p);
    }

    public JsonList(Object ... entries) {
        Collections.addAll(this, entries);
    }

    public static JsonList create() {
        return new JsonList();
    }

    public static JsonList of(Collection<?> values) {
        return values == null ? null : new JsonList(values);
    }

    public static JsonList ofCollections(Collection<?> ... values) {
        JsonList l = new JsonList();
        for (Collection<?> v : values) {
            l.add(v);
        }
        return l;
    }

    public static JsonList ofArrays(Object[] ... values) {
        JsonList l = new JsonList();
        for (Object[] v : values) {
            l.add(v);
        }
        return l;
    }

    public static JsonList ofJson(CharSequence json) throws ParseException {
        return json == null ? null : new JsonList(json);
    }

    public static JsonList ofText(CharSequence in, Parser p) throws ParseException {
        return in == null ? null : new JsonList(in, p);
    }

    public static JsonList ofJson(Reader json) throws ParseException {
        return json == null ? null : new JsonList(json);
    }

    public static JsonList ofText(Reader in, Parser p) throws ParseException {
        return in == null ? null : new JsonList(in);
    }

    public static JsonList of(Object ... values) {
        return new JsonList(values);
    }

    public JsonList session(BeanSession session) {
        this.session = session;
        return this;
    }

    public JsonList append(Object value) {
        this.add(value);
        return this;
    }

    public JsonList append(Object ... values) {
        Collections.addAll(this, values);
        return this;
    }

    public JsonList append(Collection<?> values) {
        if (values != null) {
            this.addAll(values);
        }
        return this;
    }

    public JsonList appendIf(boolean flag, Object value) {
        if (flag) {
            this.append(value);
        }
        return this;
    }

    public JsonList appendReverse(List<?> values) {
        ListIterator<?> i = values.listIterator(values.size());
        while (i.hasPrevious()) {
            this.add(i.previous());
        }
        return this;
    }

    public JsonList appendReverse(Object ... values) {
        for (int i = values.length - 1; i >= 0; --i) {
            this.add(values[i]);
        }
        return this;
    }

    public <T> JsonList appendIf(Predicate<T> test, T value) {
        return this.appendIf(ConsumerUtils.test(test, value), value);
    }

    public <T> T get(int index, Class<T> type) {
        return this.bs().convertToType(this.get(index), type);
    }

    public <T> T get(int index, Type type, Type ... args) {
        return this.bs().convertToType(this.get(index), type, args);
    }

    public String getString(int index) {
        return this.get(index, String.class);
    }

    public Integer getInt(int index) {
        return this.get(index, Integer.class);
    }

    public Boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    public JsonMap getMap(int index) {
        return this.get(index, JsonMap.class);
    }

    public <K, V> Map<K, V> getMap(int index, Class<K> keyType, Class<V> valType) {
        return (Map)this.bs().convertToType(this.get(index), (Type)((Object)Map.class), keyType, valType);
    }

    public JsonList getList(int index) {
        return this.get(index, JsonList.class);
    }

    public <E> List<E> getList(int index, Class<E> elementType) {
        return (List)this.bs().convertToType(this.get(index), (Type)((Object)List.class), elementType);
    }

    public <T> T getAt(String path, Class<T> type) {
        return this.getObjectRest().get(path, type);
    }

    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getObjectRest().get(path, type, args);
    }

    public Object putAt(String path, Object o) {
        return this.getObjectRest().put(path, o);
    }

    public Object postAt(String path, Object o) {
        return this.getObjectRest().post(path, o);
    }

    public Object deleteAt(String path) {
        return this.getObjectRest().delete(path);
    }

    public BeanSession getBeanSession() {
        return this.session;
    }

    public JsonList setBeanSession(BeanSession value) {
        this.session = value;
        return this;
    }

    public <E> Iterable<E> elements(final Class<E> childType) {
        final Iterator iterator = this.iterator();
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return JsonList.this.bs().convertToType(iterator.next(), childType);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public ClassMeta<?> getClassMeta(int index) {
        return this.bs().getClassMetaForObject(this.get(index));
    }

    public String asString(WriterSerializer serializer) {
        return serializer.toString(this);
    }

    public String asString() {
        return Json5Serializer.DEFAULT.toString(this);
    }

    public boolean isUnmodifiable() {
        return false;
    }

    public JsonList modifiable() {
        if (this.isUnmodifiable()) {
            return new JsonList((Collection<?>)this);
        }
        return this;
    }

    public JsonList unmodifiable() {
        if (this instanceof UnmodifiableJsonList) {
            return this;
        }
        return new UnmodifiableJsonList(this);
    }

    public JsonList writeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this, w);
        return this;
    }

    public Object cast(ClassMeta<?> cm) {
        try {
            return JsonParser.DEFAULT.parse(Json5Serializer.DEFAULT.serialize(this), cm);
        }
        catch (ParseException | SerializeException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    private void parse(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoCollection(r, this, this.bs().object());
    }

    private ObjectRest getObjectRest() {
        if (this.objectRest == null) {
            this.objectRest = new ObjectRest(this);
        }
        return this.objectRest;
    }

    BeanSession bs() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT_SESSION;
        }
        return this.session;
    }

    public String asJson() {
        return this.toString();
    }

    @Override
    public String toString() {
        return Json5.of(this);
    }

    private static final class UnmodifiableJsonList
    extends JsonList {
        private static final long serialVersionUID = 1L;

        UnmodifiableJsonList(JsonList contents) {
            if (contents != null) {
                this.forEach(x$0 -> super.add(x$0));
            }
        }

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException("Not supported on read-only object.");
        }

        @Override
        public boolean isUnmodifiable() {
            return true;
        }
    }
}

