/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.marshaller.Json5;

public class ThrownStats
implements Cloneable {
    private final long guid;
    private final long hash;
    private final Class<?> thrownClass;
    private final String firstMessage;
    private final List<String> stackTrace;
    private final Optional<ThrownStats> causedBy;
    private final AtomicInteger count;
    private final AtomicLong firstOccurrence;
    private final AtomicLong lastOccurrence;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected ThrownStats(Builder builder) {
        this.guid = new Random().nextLong();
        this.thrownClass = builder.throwable.getClass();
        this.firstMessage = builder.throwable.getMessage();
        this.stackTrace = CollectionUtils.listBuilder(builder.stackTrace).copy().unmodifiable().build();
        this.causedBy = CollectionUtils.optional((Object)builder.causedBy);
        this.hash = builder.hash;
        this.count = new AtomicInteger(0);
        long ct = System.currentTimeMillis();
        this.firstOccurrence = new AtomicLong(ct);
        this.lastOccurrence = new AtomicLong(ct);
    }

    private ThrownStats(ThrownStats x) {
        this.guid = x.guid;
        this.thrownClass = x.thrownClass;
        this.firstMessage = x.firstMessage;
        this.stackTrace = CollectionUtils.listBuilder(x.stackTrace).copy().unmodifiable().build();
        this.causedBy = CollectionUtils.optional(x.causedBy.isPresent() ? x.causedBy.get().clone() : null);
        this.hash = x.hash;
        this.count = new AtomicInteger(x.count.get());
        this.firstOccurrence = new AtomicLong(x.firstOccurrence.get());
        this.lastOccurrence = new AtomicLong(x.lastOccurrence.get());
    }

    public long getGuid() {
        return this.guid;
    }

    public long getHash() {
        return this.hash;
    }

    public Class<?> getThrownClass() {
        return this.thrownClass;
    }

    public int getCount() {
        return this.count.intValue();
    }

    public long getFirstOccurrence() {
        return this.firstOccurrence.longValue();
    }

    public long getLastOccurrence() {
        return this.lastOccurrence.longValue();
    }

    public String getFirstMessage() {
        return this.firstMessage;
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public Optional<ThrownStats> getCausedBy() {
        return this.causedBy;
    }

    public ThrownStats increment() {
        this.count.incrementAndGet();
        this.lastOccurrence.set(System.currentTimeMillis());
        this.causedBy.ifPresent(ThrownStats::increment);
        return this;
    }

    public String toString() {
        return Json5.of((Object)this);
    }

    public ThrownStats clone() {
        return new ThrownStats(this);
    }

    @FluentSetters
    public static class Builder {
        final BeanStore beanStore;
        Throwable throwable;
        long hash;
        List<String> stackTrace;
        ThrownStats causedBy;
        BeanCreator<ThrownStats> creator;

        protected Builder(BeanStore beanStore) {
            this.beanStore = beanStore;
            this.creator = beanStore.createBean(ThrownStats.class).builder(Builder.class, (Object)this);
        }

        public ThrownStats build() {
            return (ThrownStats)this.creator.run();
        }

        @FluentSetter
        public Builder type(Class<? extends ThrownStats> value) {
            this.creator.type(value == null ? ThrownStats.class : value);
            return this;
        }

        @FluentSetter
        public Builder throwable(Throwable value) {
            this.throwable = value;
            return this;
        }

        @FluentSetter
        public Builder hash(long value) {
            this.hash = value;
            return this;
        }

        @FluentSetter
        public Builder stackTrace(List<String> value) {
            this.stackTrace = value;
            return this;
        }

        @FluentSetter
        public Builder causedBy(ThrownStats value) {
            this.causedBy = value;
            return this;
        }
    }
}

