/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;

public class FileUtils {
    public static File mkdirs(File f, boolean clean) {
        ArgUtils.assertArgNotNull((String)"f", (Object)f);
        if (f.exists()) {
            if (clean) {
                if (!FileUtils.delete(f)) {
                    throw new BasicRuntimeException("Could not clean directory ''{0}''", f.getAbsolutePath());
                }
            } else {
                return f;
            }
        }
        if (!f.mkdirs()) {
            throw new BasicRuntimeException("Could not create directory ''{0}''", f.getAbsolutePath());
        }
        return f;
    }

    public static File mkdirs(String path, boolean clean) {
        ArgUtils.assertArgNotNull((String)"path", (Object)path);
        return FileUtils.mkdirs(new File(path), clean);
    }

    public static boolean delete(File f) {
        File[] cf;
        if (f == null) {
            return true;
        }
        if (f.isDirectory() && (cf = f.listFiles()) != null) {
            for (File c : cf) {
                FileUtils.delete(c);
            }
        }
        return f.delete();
    }

    public static void create(File f) {
        if (f.exists()) {
            return;
        }
        try {
            if (!f.createNewFile()) {
                throw new BasicRuntimeException("Could not create file ''{0}''", f.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    public static void modifyTimestamp(File f) {
        long l;
        long lm = f.lastModified();
        if (lm == (l = System.currentTimeMillis())) {
            ++l;
        }
        if (!f.setLastModified(l)) {
            throw new BasicRuntimeException("Could not modify timestamp on file ''{0}''", f.getAbsolutePath());
        }
        if (lm == f.lastModified() && !f.setLastModified(l += 1000L)) {
            throw new BasicRuntimeException("Could not modify timestamp on file ''{0}''", f.getAbsolutePath());
        }
    }

    public static File createTempFile(String name) throws IOException {
        String[] parts = name.split("\\.");
        File f = File.createTempFile(parts[0], "." + parts[1]);
        f.deleteOnExit();
        return f;
    }

    public static File createTempFile(String name, String contents) throws IOException {
        File f = FileUtils.createTempFile(name);
        try (StringReader r = new StringReader(contents);
             FileWriter w = new FileWriter(f);){
            IOUtils.pipe((Reader)r, (Writer)w);
            ((Writer)w).flush();
        }
        return f;
    }

    public static String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static boolean exists(File dir, String fileName) {
        if (dir == null || fileName == null) {
            return false;
        }
        return Files.exists(dir.toPath().resolve(fileName), new LinkOption[0]);
    }

    public static boolean hasExtension(String name, String ext) {
        if (name == null || ext == null) {
            return false;
        }
        return ext.equals(FileUtils.getExtension(name));
    }

    public static String getFileName(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        int i = (path = StringUtils.trimTrailingSlashes((String)path)).lastIndexOf(47);
        return i == -1 ? path : path.substring(i + 1);
    }
}

