/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.status.StatusLogger;

public final class SslConfigurationFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private SslConfigurationFactory() {
    }

    public static SslConfiguration getSslConfiguration(PropertyEnvironment props) {
        return SslConfigurationFactory.getSslConfiguration((CoreProperties.TransportSecurityProperties)props.getProperty(CoreProperties.TransportSecurityProperties.class));
    }

    static SslConfiguration getSslConfiguration(CoreProperties.TransportSecurityProperties config) {
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustStoreConfiguration trustStoreConfiguration = null;
        if (config != null) {
            CoreProperties.KeyStoreProperties keyStoreProperties;
            CoreProperties.KeyStoreProperties trustStoreProperties = config.trustStore();
            if (trustStoreProperties.location() != null || trustStoreProperties.type() != null) {
                try {
                    trustStoreConfiguration = TrustStoreConfiguration.createKeyStoreConfiguration(trustStoreProperties);
                }
                catch (Exception error) {
                    LOGGER.error("Failed to create the trust store configuration", (Throwable)error);
                }
            }
            if ((keyStoreProperties = config.keyStore()).location() != null || keyStoreProperties.type() != null) {
                try {
                    keyStoreConfiguration = KeyStoreConfiguration.createKeyStoreConfiguration(keyStoreProperties);
                }
                catch (Exception error) {
                    LOGGER.error("Failed to create the key store configuration", (Throwable)error);
                }
            }
        }
        return trustStoreConfiguration != null || keyStoreConfiguration != null ? SslConfiguration.createSSLConfiguration(null, keyStoreConfiguration, trustStoreConfiguration, config.verifyHostName()) : null;
    }
}

