/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.net.InetSocketAddress;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.AbstractDatagramSessionConfig;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.apr.AprSession;
import org.apache.tomcat.jni.Socket;

class AprDatagramSession
extends AprSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("apr", "datagram", true, false, InetSocketAddress.class, DatagramSessionConfig.class, new Class[]{IoBuffer.class});

    AprDatagramSession(IoService service, IoProcessor<AprSession> processor, long descriptor, InetSocketAddress remoteAddress) throws Exception {
        super(service, processor, descriptor, remoteAddress);
        this.config = new SessionConfigImpl();
        this.config.setAll(service.getSessionConfig());
    }

    public DatagramSessionConfig getConfig() {
        return (DatagramSessionConfig)this.config;
    }

    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    private class SessionConfigImpl
    extends AbstractDatagramSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isReuseAddress() {
            try {
                return Socket.optGet((long)AprDatagramSession.this.getDescriptor(), (int)16) == 1;
            }
            catch (Exception e) {
                throw new RuntimeIoException("Failed to get SO_REUSEADDR.", (Throwable)e);
            }
        }

        public void setReuseAddress(boolean on) {
            Socket.optSet((long)AprDatagramSession.this.getDescriptor(), (int)16, (int)(on ? 1 : 0));
        }

        public int getTrafficClass() {
            return 0;
        }

        public void setTrafficClass(int tc) {
        }

        public int getSendBufferSize() {
            try {
                return Socket.optGet((long)AprDatagramSession.this.getDescriptor(), (int)64);
            }
            catch (Exception e) {
                throw new IllegalStateException("APR Exception", e);
            }
        }

        public void setSendBufferSize(int size) {
            Socket.optSet((long)AprDatagramSession.this.getDescriptor(), (int)64, (int)size);
        }

        public int getReceiveBufferSize() {
            try {
                return Socket.optGet((long)AprDatagramSession.this.getDescriptor(), (int)128);
            }
            catch (Exception e) {
                throw new IllegalStateException("APR Exception", e);
            }
        }

        public void setReceiveBufferSize(int size) {
            Socket.optSet((long)AprDatagramSession.this.getDescriptor(), (int)128, (int)size);
        }

        public boolean isBroadcast() {
            return false;
        }

        public void setBroadcast(boolean broadcast) {
        }
    }
}

