/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.client.kex.AbstractDHClientKeyExchange;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.CurveSizeIndicator;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyEncapsulationMethod;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class DHGClient
extends AbstractDHClientKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;
    private KeyEncapsulationMethod.Client kemClient;

    protected DHGClient(DHFactory factory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory delegate) {
        return new KeyExchangeFactory(){

            public String getName() {
                return delegate.getName();
            }

            @Override
            public KeyExchange createKeyExchange(Session session) throws Exception {
                return new DHGClient(delegate, session);
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        byte[] e;
        super.init(v_s, v_c, i_s, i_c);
        this.dh = this.getDH();
        this.hash = this.dh.getHash();
        this.hash.init();
        KeyEncapsulationMethod kem = this.dh.getKeyEncapsulation();
        if (kem == null) {
            e = this.updateE(this.dh.getE());
        } else {
            this.kemClient = kem.getClient();
            this.kemClient.init();
            e = this.kemClient.getPublicKey();
            byte[] dhE = this.dh.getE();
            int l = e.length;
            e = Arrays.copyOf(e, l + dhE.length);
            System.arraycopy(dhE, 0, e, l, dhE.length);
            e = this.updateE(e);
        }
        Session s = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({})[{}] Send SSH_MSG_KEXDH_INIT", (Object)this, (Object)s);
        }
        Buffer buffer = s.createBuffer((byte)30, e.length + 32);
        this.dh.putE(buffer, e);
        s.writePacket(buffer);
    }

    protected AbstractDH getDH() throws Exception {
        return this.factory.create(new Object[0]);
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        PublicKey serverKey;
        AbstractClientSession session = this.getClientSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, session, KeyExchange.getSimpleKexOpcodeName(cmd)});
        }
        if (cmd != 31) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_REPLY, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        byte[] k_s = buffer.getBytes();
        byte[] f = this.updateF(buffer);
        byte[] sig = buffer.getBytes();
        if (this.kemClient == null) {
            this.dh.setF(f);
            this.k = this.normalize(this.dh.getK());
        } else {
            try {
                int l = this.kemClient.getEncapsulationLength();
                if (this.dh instanceof CurveSizeIndicator) {
                    int expectedLength = l + ((CurveSizeIndicator)((Object)this.dh)).getByteLength();
                    if (f.length != expectedLength) {
                        throw new SshException(3, "Wrong F length (should be " + expectedLength + " bytes): " + f.length);
                    }
                } else if (f.length <= l) {
                    throw new SshException(3, "Strange F length: " + f.length + "  <= " + l);
                }
                this.dh.setF(Arrays.copyOfRange(f, l, f.length));
                Digest keyHash = this.dh.getHash();
                keyHash.init();
                keyHash.update(this.kemClient.extractSecret(Arrays.copyOf(f, l)));
                keyHash.update(this.dh.getK());
                this.k = keyHash.digest();
            }
            catch (IllegalArgumentException ex) {
                this.log.error("Key encapsulation error", (Throwable)ex);
                throw new SshException(3, "Key encapsulation error: " + ex.getMessage());
            }
        }
        String keyAlg = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        boolean wantCert = KeyUtils.isCertificateAlgorithm((String)keyAlg);
        buffer = new ByteArrayBuffer(k_s);
        PublicKey serverPublicHostKey = serverKey = buffer.getRawPublicKey();
        if (serverKey instanceof OpenSshCertificate) {
            OpenSshCertificate openSshKey = (OpenSshCertificate)serverKey;
            if (!wantCert) {
                this.log.error("Got a server key certificate, but negotiated algorithm is {}", (Object)keyAlg);
                throw new SshException(3, "OpenSshCertificate found with KEX algorithm " + keyAlg);
            }
            serverPublicHostKey = openSshKey.getCertPubKey();
            try {
                this.verifyCertificate(session, openSshKey);
            }
            catch (SshException e) {
                if (((Boolean)CoreModuleProperties.ABORT_ON_INVALID_CERTIFICATE.getRequired((PropertyResolver)session)).booleanValue()) {
                    throw e;
                }
                serverKey = openSshKey.getCertPubKey();
                this.log.info("Ignoring invalid certificate {}", (Object)openSshKey.getId(), (Object)e);
            }
        } else if (wantCert) {
            this.log.error("Got a plain public key (not a certificate) for negotiated algorithm {}", (Object)keyAlg);
            throw new SshException(3, "Server did not send a certificate with KEX algorithm " + keyAlg);
        }
        buffer = new ByteArrayBuffer();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        this.dh.putE(buffer, this.getE());
        this.dh.putF(buffer, f);
        buffer.putBytes(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        Signature verif = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(session.getSignatureFactories(), (String)keyAlg)), (String)"No verifier located for algorithm=%s", (Object)keyAlg);
        verif.initVerifier((SessionContext)session, serverPublicHostKey);
        verif.update((SessionContext)session, this.h);
        if (!verif.verify((SessionContext)session, sig)) {
            throw new SshException(3, "KeyExchange signature verification failed for key type=" + keyAlg);
        }
        session.setServerKey(serverKey);
        return true;
    }

    protected void verifyCertificate(Session session, OpenSshCertificate openSshKey) throws Exception {
        PublicKey signatureKey = openSshKey.getCaPubKey();
        String keyAlg = KeyUtils.getKeyType((Key)signatureKey);
        String keyId = openSshKey.getId();
        if (!OpenSshCertificate.Type.HOST.equals((Object)openSshKey.getType())) {
            throw new SshException(3, "KeyExchange signature verification failed, not a host key (2) " + openSshKey.getType() + " for key ID=" + keyId);
        }
        if (!OpenSshCertificate.isValidNow((OpenSshCertificate)openSshKey)) {
            throw new SshException(3, "KeyExchange signature verification failed, CA expired for key ID=" + keyId);
        }
        String sigAlg = openSshKey.getSignatureAlgorithm();
        if (!keyAlg.equals(KeyUtils.getCanonicalKeyType((String)sigAlg))) {
            throw new SshException(3, "Found invalid signature alg " + sigAlg + " for key ID=" + keyId + " using a " + keyAlg + " CA key");
        }
        Signature verif = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)session.getSignatureFactories(), (String)sigAlg)), (String)"No KeyExchange CA verifier located for algorithm=%s of key ID=%s", (Object[])new Object[]{sigAlg, keyId});
        verif.initVerifier((SessionContext)session, signatureKey);
        verif.update((SessionContext)session, openSshKey.getMessage());
        if (!verif.verify((SessionContext)session, openSshKey.getSignature())) {
            throw new SshException(3, "KeyExchange CA signature verification failed for key type=" + keyAlg + " of key ID=" + keyId);
        }
        Collection principals = openSshKey.getPrincipals();
        if (!GenericUtils.isEmpty((Collection)principals)) {
            SocketAddress connectSocketAddress = this.getClientSession().getConnectAddress();
            if (connectSocketAddress instanceof SshdSocketAddress) {
                connectSocketAddress = ((SshdSocketAddress)connectSocketAddress).toInetSocketAddress();
            }
            if (connectSocketAddress instanceof InetSocketAddress) {
                String hostName = ((InetSocketAddress)connectSocketAddress).getHostString();
                if (GenericUtils.isEmpty((Collection)principals) || !principals.contains(hostName)) {
                    throw new SshException(3, "KeyExchange signature verification failed, invalid principal " + hostName + " for key ID=" + keyId + " - allowed=" + principals);
                }
            } else {
                throw new SshException(3, "KeyExchange signature verification failed, could not determine connect host for key ID=" + keyId);
            }
        }
        if (!GenericUtils.isEmpty((Collection)openSshKey.getCriticalOptions())) {
            throw new SshException(3, "KeyExchange signature verification failed, unrecognized critical options " + openSshKey.getCriticalOptions() + " for key ID=" + keyId);
        }
    }
}

