/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.util.ClassLoaderExtension;

public final class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);
    public static final Class BOOLEAN_ARRAY_CLASS = boolean[].class;
    public static final Class BYTE_ARRAY_CLASS = byte[].class;
    public static final Class CHAR_ARRAY_CLASS = char[].class;
    public static final Class SHORT_ARRAY_CLASS = short[].class;
    public static final Class INT_ARRAY_CLASS = int[].class;
    public static final Class LONG_ARRAY_CLASS = long[].class;
    public static final Class FLOAT_ARRAY_CLASS = float[].class;
    public static final Class DOUBLE_ARRAY_CLASS = double[].class;
    public static final Class OBJECT_ARRAY_CLASS = Object[].class;
    public static final Class BOOLEAN_OBJECT_ARRAY_CLASS = Boolean[].class;
    public static final Class BYTE_OBJECT_ARRAY_CLASS = Byte[].class;
    public static final Class CHARACTER_OBJECT_ARRAY_CLASS = Character[].class;
    public static final Class SHORT_OBJECT_ARRAY_CLASS = Short[].class;
    public static final Class INTEGER_OBJECT_ARRAY_CLASS = Integer[].class;
    public static final Class LONG_OBJECT_ARRAY_CLASS = Long[].class;
    public static final Class FLOAT_OBJECT_ARRAY_CLASS = Float[].class;
    public static final Class DOUBLE_OBJECT_ARRAY_CLASS = Double[].class;
    public static final Class STRING_OBJECT_ARRAY_CLASS = String[].class;
    public static ClassLoaderExtension[] classLoadingExtensions = new ClassLoaderExtension[0];
    public static final Map COMMON_TYPES = new HashMap(64);

    private ClassUtils() {
    }

    public static void addClassLoadingExtension(ClassLoaderExtension extension, boolean top) {
        ClassLoaderExtension[] retVal = new ClassLoaderExtension[classLoadingExtensions.length + 1];
        ArrayList<ClassLoaderExtension> extensions = new ArrayList<ClassLoaderExtension>(classLoadingExtensions.length + 1);
        extensions.add(extension);
        classLoadingExtensions = extensions.toArray(retVal);
    }

    public static Class classForName(String type) throws ClassNotFoundException {
        ClassLoaderExtension[] loaderPlugins = classLoadingExtensions;
        int plugins = loaderPlugins.length;
        for (int cnt = 0; cnt < loaderPlugins.length; ++cnt) {
            ClassLoaderExtension extension = loaderPlugins[cnt];
            Class retVal = extension.forName(type);
            if (retVal == null) continue;
            return retVal;
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, ClassUtils.getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, ClassUtils.class.getClassLoader());
        }
    }

    public static Class simpleClassForName(String type) {
        try {
            return ClassUtils.classForName(type);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class " + type + " not found"), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Class javaTypeToClass(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Class clazz = (Class)COMMON_TYPES.get(type);
        if (clazz != null) {
            return clazz;
        }
        int len = type.length();
        if (len > 2 && type.charAt(len - 1) == ']' && type.charAt(len - 2) == '[') {
            String componentType = type.substring(0, len - 2);
            Class componentTypeClass = ClassUtils.classForName(componentType);
            return Array.newInstance(componentTypeClass, 0).getClass();
        }
        return ClassUtils.classForName(type);
    }

    public static Class simpleJavaTypeToClass(String type) {
        try {
            return ClassUtils.javaTypeToClass(type);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class " + type + " not found"), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream stream = ClassUtils.getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassUtils.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    public static Iterator getResources(String resource, Object defaultObject) {
        try {
            Enumeration<URL> resources = ClassUtils.getCurrentLoader(defaultObject).getResources(resource);
            ArrayList<URL> lst = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                lst.add(resources.nextElement());
            }
            return lst.iterator();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Object newInstance(String type) throws FacesException {
        if (type == null) {
            return null;
        }
        return ClassUtils.newInstance(ClassUtils.simpleClassForName(type));
    }

    public static Object newInstance(String type, Class expectedType) throws FacesException {
        Class[] classArray;
        if (expectedType == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = expectedType;
        }
        return ClassUtils.newInstance(type, classArray);
    }

    public static Object newInstance(String type, Class[] expectedTypes) {
        if (type == null) {
            return null;
        }
        Class clazzForName = ClassUtils.simpleClassForName(type);
        if (expectedTypes != null) {
            int size = expectedTypes.length;
            for (int i = 0; i < size; ++i) {
                if (expectedTypes[i].isAssignableFrom(clazzForName)) continue;
                throw new FacesException("'" + type + "' does not implement expected type '" + expectedTypes[i] + "'");
            }
        }
        return ClassUtils.newInstance(clazzForName);
    }

    public static Object newInstance(Class clazz) throws FacesException {
        try {
            return clazz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)("Class : " + clazz.getName() + " not found."), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static Object convertToType(Object value, Class desiredClass) {
        if (value == null) {
            return null;
        }
        try {
            ExpressionFactory expFactory = FacesContext.getCurrentInstance().getApplication().getExpressionFactory();
            return expFactory.coerceToType(value, desiredClass);
        }
        catch (Exception e) {
            String message = "Cannot coerce " + value.getClass().getName() + " to " + desiredClass.getName();
            log.error((Object)message, (Throwable)e);
            throw new FacesException(message, (Throwable)e);
        }
    }

    protected static ClassLoader getCurrentLoader(Object defaultObject) {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws PrivilegedActionException {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                return cl;
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException((Throwable)pae);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static {
        COMMON_TYPES.put("byte", Byte.TYPE);
        COMMON_TYPES.put("char", Character.TYPE);
        COMMON_TYPES.put("double", Double.TYPE);
        COMMON_TYPES.put("float", Float.TYPE);
        COMMON_TYPES.put("int", Integer.TYPE);
        COMMON_TYPES.put("long", Long.TYPE);
        COMMON_TYPES.put("short", Short.TYPE);
        COMMON_TYPES.put("boolean", Boolean.TYPE);
        COMMON_TYPES.put("void", Void.TYPE);
        COMMON_TYPES.put("java.lang.Object", Object.class);
        COMMON_TYPES.put("java.lang.Boolean", Boolean.class);
        COMMON_TYPES.put("java.lang.Byte", Byte.class);
        COMMON_TYPES.put("java.lang.Character", Character.class);
        COMMON_TYPES.put("java.lang.Short", Short.class);
        COMMON_TYPES.put("java.lang.Integer", Integer.class);
        COMMON_TYPES.put("java.lang.Long", Long.class);
        COMMON_TYPES.put("java.lang.Float", Float.class);
        COMMON_TYPES.put("java.lang.Double", Double.class);
        COMMON_TYPES.put("java.lang.String", String.class);
        COMMON_TYPES.put("byte[]", BYTE_ARRAY_CLASS);
        COMMON_TYPES.put("char[]", CHAR_ARRAY_CLASS);
        COMMON_TYPES.put("double[]", DOUBLE_ARRAY_CLASS);
        COMMON_TYPES.put("float[]", FLOAT_ARRAY_CLASS);
        COMMON_TYPES.put("int[]", INT_ARRAY_CLASS);
        COMMON_TYPES.put("long[]", LONG_ARRAY_CLASS);
        COMMON_TYPES.put("short[]", SHORT_ARRAY_CLASS);
        COMMON_TYPES.put("boolean[]", BOOLEAN_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Object[]", OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Boolean[]", BOOLEAN_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Byte[]", BYTE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Character[]", CHARACTER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Short[]", SHORT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Integer[]", INTEGER_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Long[]", LONG_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Float[]", FLOAT_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.Double[]", DOUBLE_OBJECT_ARRAY_CLASS);
        COMMON_TYPES.put("java.lang.String[]", STRING_OBJECT_ARRAY_CLASS);
    }
}

