/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class<?> returnTypeClass;
    private final Class<?>[] params;

    public MethodRule(String methodName, Class<?> returnTypeClass, Class<?>[] params) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodExpression.class.equals((Object)meta.getPropertyType(name)) && (method = meta.getWriteMethod(name)) != null) {
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private class MethodExpressionMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class<?>[] _paramList;
        private Class<?> _returnType;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class<?> returnType, Class<?>[] paramList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, this._paramList);
            try {
                this._method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

