/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.renderkit.ConvertedValueCache;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererProxy;
import org.apache.myfaces.extensions.validator.core.renderkit.RendererProxy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
class ExtValLazyRendererProxy
extends Renderer
implements RendererProxy {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private Renderer wrapped;

    public ExtValLazyRendererProxy(Renderer renderer) {
        this.wrapped = renderer;
        this.logger.finest("simple proxy created for " + renderer.getClass().getName());
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        this.getLazyRenderer().decode(facesContext, uiComponent);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.getLazyRenderer().encodeBegin(facesContext, uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.getLazyRenderer().encodeChildren(facesContext, uiComponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.getLazyRenderer().encodeEnd(facesContext, uiComponent);
    }

    public String convertClientId(FacesContext facesContext, String s) {
        return this.getLazyRenderer().convertClientId(facesContext, s);
    }

    public boolean getRendersChildren() {
        return this.getLazyRenderer().getRendersChildren();
    }

    public Object getCachedConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o) throws ConverterException {
        Renderer renderer = this.getLazyRenderer();
        if (renderer instanceof RendererProxy) {
            return ((RendererProxy)this.getLazyRenderer()).getCachedConvertedValue(facesContext, uiComponent, o);
        }
        if (ConvertedValueCache.isCachedValueAvailable()) {
            return ConvertedValueCache.getCachedValue();
        }
        Object result = renderer.getConvertedValue(facesContext, uiComponent, o);
        ConvertedValueCache.setCachedValue(result);
        return result;
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o) throws ConverterException {
        if (this.getLazyRenderer() == this.wrapped && ConvertedValueCache.isCachedValueAvailable()) {
            return ConvertedValueCache.getCachedValue();
        }
        return this.getLazyRenderer().getConvertedValue(facesContext, uiComponent, o);
    }

    private Renderer getLazyRenderer() {
        Class<? extends ExtValRendererProxy> targetClass = ExtValCoreConfiguration.get().rendererProxy();
        if (targetClass != null) {
            Class[] argClasses = new Class[]{Renderer.class};
            try {
                Constructor<? extends ExtValRendererProxy> constructor = targetClass.getConstructor(argClasses);
                return constructor.newInstance(this.wrapped);
            }
            catch (Exception e) {
                this.logger.warning("couldn't create: " + targetClass.getName());
                return this.wrapped;
            }
        }
        return this.wrapped;
    }

    public Renderer getWrappedRenderer() {
        return this.wrapped;
    }

    void resetConvertedValueCache() {
        ConvertedValueCache.reset();
    }
}

