/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.jsf.components.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import org.apache.myfaces.orchestra.lib.jsf.SerializableConverter;

import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import java.io.IOException;

public class ConverterTagHandler extends TagHandler
{
    private final TagAttribute beanName;
    private final TagAttribute useWrapper;

    public ConverterTagHandler(TagConfig config)
    {
        super(config);
        beanName = getRequiredAttribute("beanName"); // NON-NLS
        useWrapper = getAttribute("useWrapper"); // NON-NLS
    }

    public void apply(FaceletContext faceletContext, UIComponent parent)
    throws IOException, FacesException, FaceletException, ELException
    {
        if (parent.getParent() == null)
        {
            if (parent instanceof EditableValueHolder)
            {
                Converter converter = createConverter(beanName.getValue());

                if (useWrapper == null || !"false".equals(useWrapper.getValue()) &&
                    !(converter instanceof SerializableConverter))
                {
                    // Needed to check if it is already of the specified type in case the
                    // managed-bean framework has been configured to auto-wrap Converter
                    // instances already (eg via a Spring BeanPostProcessor or equivalent).
                    // This isn't the case, so wrap it now.
                    converter = new SerializableConverter(beanName.getValue(), converter);
                }

                ((EditableValueHolder) parent).setConverter(converter);
            }
            else
            {
                throw new FacesException("parent is not an EditableValueHolder");
            }
        }
    }

    /**
     * Override this method in order to customise the bean instance.
     */
    protected static Converter createConverter(String beanName)
    {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        Object converter = application.getVariableResolver().resolveVariable(facesContext, beanName);
        return (Converter) converter;
    }
}
