/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterProvider;

public class ConversationRequestParameterProvider
implements RequestParameterProvider {
    private static final String[] NO_PARAMETERS = new String[0];
    private static final String[] REQUEST_PARAMETERS = new String[]{"conversationContext"};
    private static final ThreadLocal inSeparationModeThreadLocal = new ThreadLocal();

    public static void setInSeparationMode(boolean separationMode) {
        inSeparationModeThreadLocal.set(separationMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isInSeparationMode() {
        return Boolean.TRUE.equals(inSeparationModeThreadLocal.get());
    }

    public String getFieldValue(String field) {
        if (ConversationRequestParameterProvider.isInSeparationMode()) {
            return null;
        }
        ConversationManager conversationManager = ConversationManager.getInstance();
        if (conversationManager == null) {
            throw new IllegalStateException("can find the conversationManager");
        }
        ConversationContext ctx = conversationManager.getOrCreateCurrentConversationContext();
        return Long.toString(ctx.getId(), 36);
    }

    public String[] getFields() {
        if (ConversationRequestParameterProvider.isInSeparationMode()) {
            return NO_PARAMETERS;
        }
        return REQUEST_PARAMETERS;
    }
}

