/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.frameworkAdapter;

import java.io.IOException;
import org.apache.myfaces.orchestra.conversation.ConversationMessager;

public abstract class FrameworkAdapter {
    private static final ThreadLocal instanceThreadLocal = new ThreadLocal();
    private ConversationMessager conversationMessager;
    private boolean prepared = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentInstance(FrameworkAdapter frameworkAdapter) {
        if (frameworkAdapter == null) {
            instanceThreadLocal.remove();
            return;
        }
        FrameworkAdapter frameworkAdapter2 = frameworkAdapter;
        synchronized (frameworkAdapter2) {
            if (!frameworkAdapter.prepared) {
                frameworkAdapter.prepare();
            }
        }
        instanceThreadLocal.set(frameworkAdapter);
    }

    public static FrameworkAdapter getCurrentInstance() {
        return (FrameworkAdapter)instanceThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        if (this.conversationMessager == null) {
            this.conversationMessager = this.createConversationMessager();
        }
        FrameworkAdapter frameworkAdapter = this;
        synchronized (frameworkAdapter) {
            this.prepared = true;
        }
    }

    protected ConversationMessager createConversationMessager() {
        throw new IllegalStateException("conversation messager configuration missing");
    }

    public ConversationMessager getConversationMessager() {
        return this.conversationMessager;
    }

    public void setConversationMessager(ConversationMessager conversationMessager) {
        this.conversationMessager = conversationMessager;
    }

    public abstract String getInitParameter(String var1);

    public abstract Object getRequestParameterAttribute(String var1);

    public abstract boolean containsRequestParameterAttribute(String var1);

    public abstract Object getRequestAttribute(String var1);

    public abstract void setRequestAttribute(String var1, Object var2);

    public abstract boolean containsRequestAttribute(String var1);

    public abstract Object getSessionAttribute(String var1);

    public abstract void setSessionAttribute(String var1, Object var2);

    public abstract boolean containsSessionAttribute(String var1);

    public abstract void redirect(String var1) throws IOException;

    public abstract Object getBean(String var1);

    public abstract void invokeNavigation(String var1) throws IOException;

    public String getCurrentViewId() {
        return "defaultView";
    }
}

