/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.conversation;

import java.util.Set;

/**
 * Provides configuration information to a AccessScopeManager instance.
 * <p>
 * While an AccessScopeManager object is expected to be request-scoped, an instance
 * of this type is usually application-scoped (aka singleton scoped).
 * 
 * @since 1.1
 */
public class AccessScopeManagerConfiguration
{
    private Set ignoreViewIds;

    public Set getIgnoreViewIds()
    {
        return ignoreViewIds;
    }

    /**
     * Do not terminate any "unaccessed conversations" after handling a request to
     * any of the specified views.
     * 
     * Special "ignored views" are useful when dealing with things like nested
     * frames within a page that periodically refresh themselves while the "main"
     * part of the page remains unsubmitted.
     */
    public void setIgnoreViewIds(Set ignoreViewIds)
    {
        this.ignoreViewIds = ignoreViewIds;
    }
}
