/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.jsf.components;

import javax.faces.component.UIComponent;

/**
 * End a conversation.
 * <p>
 * When a conversation ends, all objects stored in that conversation are discarded.
 *
 * @see org.apache.myfaces.orchestra.conversation.jsf.components.UIEndConversation
 */
public class EndConversationTag extends AbstractConversationTag
{
    private String onOutcome;
    private String errorOutcome;

    public String getComponentType()
    {
        return UIEndConversation.COMPONENT_TYPE;
    }

    protected void setProperties(UIComponent component)
    {
        super.setProperties(component);

        setStringProperty(component, "onOutcome", getOnOutcome());
        setStringProperty(component, "errorOutcome", getErrorOutcome());
    }

    public String getOnOutcome()
    {
        return onOutcome;
    }

    public void setOnOutcome(String onOutcome)
    {
        this.onOutcome = onOutcome;
    }

    public String getErrorOutcome()
    {
        return errorOutcome;
    }

    public void setErrorOutcome(String errorOutcome)
    {
        this.errorOutcome = errorOutcome;
    }
}
