/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class _ReentrantLock
implements Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private static final long WAIT_WARN_MILLIS = 30000L;
    private final Log log = LogFactory.getLog(_ReentrantLock.class);
    private transient Thread lockedBy;
    private int lockCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockInterruptibly() throws InterruptedException {
        Thread caller = Thread.currentThread();
        while (true) {
            _ReentrantLock _ReentrantLock2 = this;
            synchronized (_ReentrantLock2) {
                if (this.lockedBy == null) {
                    this.lockedBy = caller;
                    this.lockCount = 1;
                    return;
                }
                if (this.lockedBy == caller) {
                    ++this.lockCount;
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Waiting for lock " + this.toString() + " which is owned by thread " + this.lockedBy.getName()));
                }
                long beganAt = System.currentTimeMillis();
                this.wait(30000L);
                long waitedFor = System.currentTimeMillis() - beganAt;
                if (waitedFor >= 30000L && this.log.isWarnEnabled()) {
                    String lockedByName = this.lockedBy != null ? this.lockedBy.getName() : "(none)";
                    this.log.warn((Object)("Waited for longer than 30000 milliseconds for access to lock " + this.toString() + " which is locked by thread " + lockedByName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Thread caller = Thread.currentThread();
        _ReentrantLock _ReentrantLock2 = this;
        synchronized (_ReentrantLock2) {
            if (this.lockedBy != caller) {
                throw new IllegalStateException("Unlock on lock not owned by caller");
            }
            --this.lockCount;
            if (this.lockCount == 0) {
                this.lockedBy = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeldByCurrentThread() {
        Thread caller = Thread.currentThread();
        _ReentrantLock _ReentrantLock2 = this;
        synchronized (_ReentrantLock2) {
            return this.lockedBy == caller;
        }
    }
}

