/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GridLayoutConstraintTag
extends TagSupport {
    private static final long serialVersionUID = 4L;
    private static final Logger LOG = LoggerFactory.getLogger(GridLayoutConstraintTag.class);
    private ValueExpression borderBottom;
    private ValueExpression borderLeft;
    private ValueExpression borderRight;
    private ValueExpression borderTop;
    private ValueExpression columnSpan;
    private ValueExpression height;
    private ValueExpression marginBottom;
    private ValueExpression marginLeft;
    private ValueExpression marginRight;
    private ValueExpression marginTop;
    private ValueExpression maximumHeight;
    private ValueExpression maximumWidth;
    private ValueExpression minimumHeight;
    private ValueExpression minimumWidth;
    private ValueExpression paddingBottom;
    private ValueExpression paddingLeft;
    private ValueExpression paddingRight;
    private ValueExpression paddingTop;
    private ValueExpression preferredHeight;
    private ValueExpression preferredWidth;
    private ValueExpression rowSpan;
    private ValueExpression width;

    public int doStartTag() throws JspException {
        UIComponentClassicTagBase tag = UIComponentELTag.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (component.getParent() != null && component.getParent().getClass().getName().endsWith("UIExtensionPanel")) {
            component = component.getParent();
        }
        LayoutBase layoutBase = (LayoutBase)component;
        boolean isLayoutContainer = component instanceof LayoutContainer;
        boolean isLayoutComponent = component instanceof LayoutComponent;
        LayoutContainer layoutContainer = isLayoutContainer ? (LayoutContainer)component : null;
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        if (this.columnSpan != null) {
            if (isLayoutComponent) {
                component.setValueExpression("columnSpan", this.columnSpan);
            } else {
                LOG.warn("Ignoring 'columnSpan', because the parent is not a LayoutComponent!");
            }
        }
        if (this.rowSpan != null) {
            if (isLayoutComponent) {
                component.setValueExpression("rowSpan", this.rowSpan);
            } else {
                LOG.warn("Ignoring 'rowSpan', because the parent is not a LayoutComponent!");
            }
        }
        if (this.width != null) {
            if (this.width.isLiteralText()) {
                layoutBase.setWidth(Measure.valueOf(this.width.getValue(elContext)));
            } else {
                component.setValueExpression("width", this.width);
            }
        }
        if (this.height != null) {
            if (this.height.isLiteralText()) {
                layoutBase.setHeight(Measure.valueOf(this.height.getValue(elContext)));
            } else {
                component.setValueExpression("height", this.height);
            }
        }
        if (this.minimumWidth != null) {
            if (this.minimumWidth.isLiteralText()) {
                layoutBase.setMinimumWidth(Measure.valueOf(this.minimumWidth.getValue(elContext)));
            } else {
                component.setValueExpression("minimumWidth", this.minimumWidth);
            }
        }
        if (this.minimumHeight != null) {
            if (this.minimumHeight.isLiteralText()) {
                layoutBase.setMinimumHeight(Measure.valueOf(this.minimumHeight.getValue(elContext)));
            } else {
                component.setValueExpression("minimumHeight", this.minimumHeight);
            }
        }
        if (this.preferredWidth != null) {
            if (this.preferredWidth.isLiteralText()) {
                layoutBase.setPreferredWidth(Measure.valueOf(this.preferredWidth.getValue(elContext)));
            } else {
                component.setValueExpression("preferredWidth", this.preferredWidth);
            }
        }
        if (this.preferredHeight != null) {
            if (this.preferredHeight.isLiteralText()) {
                layoutBase.setPreferredHeight(Measure.valueOf(this.preferredHeight.getValue(elContext)));
            } else {
                component.setValueExpression("preferredHeight", this.preferredHeight);
            }
        }
        if (this.maximumWidth != null) {
            if (this.maximumWidth.isLiteralText()) {
                layoutBase.setMaximumWidth(Measure.valueOf(this.maximumWidth.getValue(elContext)));
            } else {
                component.setValueExpression("maximumWidth", this.maximumWidth);
            }
        }
        if (this.maximumHeight != null) {
            if (this.maximumHeight.isLiteralText()) {
                layoutBase.setMaximumHeight(Measure.valueOf(this.maximumHeight.getValue(elContext)));
            } else {
                component.setValueExpression("maximumHeight", this.maximumHeight);
            }
        }
        if (this.marginLeft != null) {
            if (this.marginLeft.isLiteralText()) {
                layoutBase.setMarginLeft(Measure.valueOf(this.marginLeft.getValue(elContext)));
            } else {
                component.setValueExpression("marginLeft", this.marginLeft);
            }
        }
        if (this.marginRight != null) {
            if (this.marginRight.isLiteralText()) {
                layoutBase.setMarginRight(Measure.valueOf(this.marginRight.getValue(elContext)));
            } else {
                component.setValueExpression("marginRight", this.marginRight);
            }
        }
        if (this.marginTop != null) {
            if (this.marginTop.isLiteralText()) {
                layoutBase.setMarginTop(Measure.valueOf(this.marginTop.getValue(elContext)));
            } else {
                component.setValueExpression("marginTop", this.marginTop);
            }
        }
        if (this.marginBottom != null) {
            if (this.marginBottom.isLiteralText()) {
                layoutBase.setMarginBottom(Measure.valueOf(this.marginBottom.getValue(elContext)));
            } else {
                component.setValueExpression("marginBottom", this.marginBottom);
            }
        }
        if (this.borderLeft != null) {
            if (isLayoutContainer) {
                if (this.borderLeft.isLiteralText()) {
                    layoutContainer.setBorderLeft(Measure.valueOf(this.borderLeft.getValue(elContext)));
                } else {
                    component.setValueExpression("borderLeft", this.borderLeft);
                }
            } else {
                LOG.warn("Ignoring 'borderLeft', because the parent is not a LayoutContainer!");
            }
        }
        if (this.borderRight != null) {
            if (isLayoutContainer) {
                if (this.borderRight.isLiteralText()) {
                    layoutContainer.setBorderRight(Measure.valueOf(this.borderRight.getValue(elContext)));
                } else {
                    component.setValueExpression("borderRight", this.borderRight);
                }
            } else {
                LOG.warn("Ignoring 'borderRight', because the parent is not a LayoutContainer!");
            }
        }
        if (this.borderTop != null) {
            if (isLayoutContainer) {
                if (this.borderTop.isLiteralText()) {
                    layoutContainer.setBorderTop(Measure.valueOf(this.borderTop.getValue(elContext)));
                } else {
                    component.setValueExpression("borderTop", this.borderTop);
                }
            } else {
                LOG.warn("Ignoring 'borderTop', because the parent is not a LayoutContainer!");
            }
        }
        if (this.borderBottom != null) {
            if (isLayoutContainer) {
                if (this.borderBottom.isLiteralText()) {
                    layoutContainer.setBorderBottom(Measure.valueOf(this.borderBottom.getValue(elContext)));
                } else {
                    component.setValueExpression("borderBottom", this.borderBottom);
                }
            } else {
                LOG.warn("Ignoring 'borderBottom', because the parent is not a LayoutContainer!");
            }
        }
        if (this.paddingLeft != null) {
            if (isLayoutContainer) {
                if (this.paddingLeft.isLiteralText()) {
                    layoutContainer.setPaddingLeft(Measure.valueOf(this.paddingLeft.getValue(elContext)));
                } else {
                    component.setValueExpression("paddingLeft", this.paddingLeft);
                }
            } else {
                LOG.warn("Ignoring 'paddingLeft', because the parent is not a LayoutContainer!");
            }
        }
        if (this.paddingRight != null) {
            if (isLayoutContainer) {
                if (this.paddingRight.isLiteralText()) {
                    layoutContainer.setPaddingRight(Measure.valueOf(this.paddingRight.getValue(elContext)));
                } else {
                    component.setValueExpression("paddingRight", this.paddingRight);
                }
            } else {
                LOG.warn("Ignoring 'paddingRight', because the parent is not a LayoutContainer!");
            }
        }
        if (this.paddingTop != null) {
            if (isLayoutContainer) {
                if (this.paddingTop.isLiteralText()) {
                    layoutContainer.setPaddingTop(Measure.valueOf(this.paddingTop.getValue(elContext)));
                } else {
                    component.setValueExpression("paddingTop", this.paddingTop);
                }
            } else {
                LOG.warn("Ignoring 'paddingTop', because the parent is not a LayoutContainer!");
            }
        }
        if (this.paddingBottom != null) {
            if (isLayoutContainer) {
                if (this.paddingBottom.isLiteralText()) {
                    layoutContainer.setPaddingBottom(Measure.valueOf(this.paddingBottom.getValue(elContext)));
                } else {
                    component.setValueExpression("paddingBottom", this.paddingBottom);
                }
            } else {
                LOG.warn("Ignoring 'paddingBottom', because the parent is not a LayoutContainer!");
            }
        }
        return 0;
    }

    public void release() {
        super.release();
        this.borderBottom = null;
        this.borderLeft = null;
        this.borderRight = null;
        this.borderTop = null;
        this.columnSpan = null;
        this.height = null;
        this.marginBottom = null;
        this.marginLeft = null;
        this.marginRight = null;
        this.marginTop = null;
        this.maximumHeight = null;
        this.maximumWidth = null;
        this.minimumHeight = null;
        this.minimumWidth = null;
        this.paddingBottom = null;
        this.paddingLeft = null;
        this.paddingRight = null;
        this.paddingTop = null;
        this.preferredHeight = null;
        this.preferredWidth = null;
        this.rowSpan = null;
        this.width = null;
    }

    public void setColumnSpan(ValueExpression columnSpan) {
        this.columnSpan = columnSpan;
    }

    public void setRowSpan(ValueExpression rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setWidth(ValueExpression width) {
        this.width = width;
    }

    public void setHeight(ValueExpression height) {
        this.height = height;
    }

    public void setMinimumWidth(ValueExpression minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public void setMinimumHeight(ValueExpression minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void setPreferredWidth(ValueExpression preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public void setPreferredHeight(ValueExpression preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public void setMaximumWidth(ValueExpression maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public void setMaximumHeight(ValueExpression maximumHeight) {
        this.maximumHeight = maximumHeight;
    }

    public void setMarginLeft(ValueExpression marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(ValueExpression marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginTop(ValueExpression marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(ValueExpression marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setBorderLeft(ValueExpression borderLeft) {
        this.borderLeft = borderLeft;
    }

    public void setBorderRight(ValueExpression borderRight) {
        this.borderRight = borderRight;
    }

    public void setBorderTop(ValueExpression borderTop) {
        this.borderTop = borderTop;
    }

    public void setBorderBottom(ValueExpression borderBottom) {
        this.borderBottom = borderBottom;
    }

    public void setPaddingLeft(ValueExpression paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(ValueExpression paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingTop(ValueExpression paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingBottom(ValueExpression paddingBottom) {
        this.paddingBottom = paddingBottom;
    }
}

