/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UISelectBooleanCheckbox;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuCommandRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MenuCommandRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenuCommand menu = (UIMenuCommand)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        boolean disabled = menu.isDisabled();
        boolean firstLevel = "MenuBar".equals(menu.getParent().getRendererType());
        if (menu.getFacet("checkbox") != null) {
            UISelectBooleanCheckbox checkbox = (UISelectBooleanCheckbox)menu.getFacet("checkbox");
            boolean checked = ComponentUtils.getBooleanAttribute((UIComponent)checkbox, (String)"value");
            String image = checked ? "image/MenuCheckmark" : null;
            String hiddenId = checkbox.getClientId(facesContext);
            CommandMap map = new CommandMap(new Command());
            LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)menu);
            this.encodeItem(facesContext, writer, menu, label, map, disabled, firstLevel, image, null, "selectBoolean", menu.getClientId());
            this.encodeHidden(writer, hiddenId, checked);
        } else if (menu.getFacet("radio") != null) {
            String clientId = menu.getClientId(facesContext);
            UISelectOne radio = (UISelectOne)menu.getFacet("radio");
            String hiddenId = radio.getClientId(facesContext);
            for (SelectItem item : SelectItemUtils.getItemIterator(facesContext, (UIComponent)radio)) {
                boolean checked = ObjectUtils.equals((Object)item.getValue(), (Object)radio.getValue());
                String image = checked ? "image/MenuRadioChecked" : null;
                String labelText = item.getLabel();
                LabelWithAccessKey label = new LabelWithAccessKey(labelText);
                String formattedValue = RenderUtils.getFormattedValue(facesContext, (UIComponent)radio, item.getValue());
                CommandMap map = new CommandMap(new Command(clientId, null, null, null, null, null, null, null, null, null));
                this.encodeItem(facesContext, writer, null, label, map, disabled, firstLevel, image, formattedValue, "selectOne", clientId);
            }
            this.encodeHidden(writer, hiddenId, this.getCurrentValue(facesContext, (UIComponent)radio));
        } else {
            String image;
            String customImage = menu.getImage();
            if (customImage != null) {
                int dot = ResourceManagerUtils.indexOfExtension((String)customImage);
                int pos = dot == -1 ? customImage.length() : dot;
                image = customImage.substring(0, pos);
            } else {
                image = null;
            }
            CommandMap map = new CommandMap(new Command(facesContext, (AbstractUICommand)menu));
            LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)menu);
            this.encodeItem(facesContext, writer, menu, label, map, disabled, firstLevel, image, null, null, menu.getClientId());
        }
    }

    private void encodeHidden(TobagoResponseWriter writer, String hiddenId, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeNameAttribute(hiddenId);
        if (value != null) {
            writer.writeAttribute("value", value.toString(), true);
        }
        writer.endElement("input");
    }

    private void encodeItem(FacesContext facesContext, TobagoResponseWriter writer, UIMenuCommand command, LabelWithAccessKey label, CommandMap map, boolean disabled, boolean firstLevel, String image, String value, String sub, String clientId) throws IOException {
        writer.startElement("li", null);
        if (command != null && !command.isTransient()) {
            writer.writeIdAttribute(clientId);
        }
        Markup markup = null;
        if (command != null) {
            markup = command.getCurrentMarkup();
            if (firstLevel) {
                markup = Markup.TOP.add(markup);
            }
        }
        String css = Classes.createWorkaround((String)"menu", (Markup)markup).getStringValue();
        if (sub != null) {
            css = css + " tobago-menu-" + sub;
        }
        writer.writeClassAttribute(css);
        if (!disabled) {
            writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
        }
        writer.writeAttribute("data-tobago-value", value, true);
        if (command != null) {
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)command);
        }
        if (image != null) {
            if (firstLevel) {
                Style iconStyle = new Style();
                iconStyle.setLeft(Measure.valueOf((int)0));
                iconStyle.setTop(Measure.valueOf((int)0));
                iconStyle.setHeight(Measure.valueOf((int)16));
                iconStyle.setWidth(Measure.valueOf((int)16));
                writer.startElement("img", null);
                String imageWithPath = ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)image, (boolean)disabled);
                writer.writeAttribute("src", imageWithPath, false);
                String imageHover = ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)(image + "Hover"), (boolean)disabled, (boolean)true);
                if (imageHover != null) {
                    writer.writeAttribute("data-tobago-src-default", imageWithPath, false);
                    writer.writeAttribute("data-tobago-src-hover", imageHover, false);
                }
                writer.writeAttribute("alt", "", false);
                writer.writeStyleAttribute(iconStyle);
                writer.endElement("img");
            } else {
                Style style = new Style();
                style.setBackgroundImage("url('" + ResourceManagerUtils.getImageOrDisabledImage((FacesContext)facesContext, (String)image, (boolean)disabled) + "')");
                writer.writeStyleAttribute(style);
            }
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", "#", false);
        if (image != null && firstLevel) {
            writer.writeStyleAttribute("vertical-align:top");
        }
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)clientId);
        }
        HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
        writer.endElement("a");
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

