/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.context.ClientPropertiesKey;

public final class ThemeConfigCacheKey {
    private final ClientPropertiesKey clientPropertiesKey;
    private final String rendererType;
    private final String name;
    private final Markup markup;
    private final int hashCode;

    public ThemeConfigCacheKey(ClientPropertiesKey clientPropertiesKey, String rendererType, Markup markup, String name) {
        this.clientPropertiesKey = clientPropertiesKey;
        this.rendererType = rendererType;
        this.markup = markup;
        this.name = name;
        this.hashCode = this.calcHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThemeConfigCacheKey cacheKey = (ThemeConfigCacheKey)o;
        if (!this.rendererType.equals(cacheKey.rendererType)) {
            return false;
        }
        if (!this.name.equals(cacheKey.name)) {
            return false;
        }
        if (this.markup != null ? !this.markup.equals(cacheKey.markup) : cacheKey.markup != null) {
            return false;
        }
        return this.clientPropertiesKey.equals(cacheKey.clientPropertiesKey);
    }

    private int calcHashCode() {
        int result = this.clientPropertiesKey.hashCode();
        result = 31 * result + this.rendererType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.markup != null ? this.markup.hashCode() : 0);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ThemeConfigCacheKey(" + this.clientPropertiesKey + "," + this.rendererType + "," + this.markup + "," + this.name + ')';
    }
}

