/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeTag
extends TagSupport {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTag.class);
    private ValueExpression name;
    private ValueExpression value;

    public int doStartTag() throws JspException {
        UIComponentClassicTagBase tag = UIComponentELTag.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        String attributeName = (String)this.name.getValue(elContext);
        if (!this.value.isLiteralText()) {
            component.setValueExpression(attributeName, this.value);
        } else if ("styleClass".equals(attributeName)) {
            ComponentUtils.setStyleClasses(component, (String)this.value.getValue(elContext));
        } else if ("renderedPartially".equals(attributeName) && component instanceof SupportsRenderedPartially) {
            String[] components = ComponentUtils.splitList((String)this.value.getValue(elContext));
            ((SupportsRenderedPartially)component).setRenderedPartially(components);
        } else {
            component.getAttributes().put(attributeName, this.value.getValue(elContext));
        }
        return 0;
    }

    public void release() {
        super.release();
        this.name = null;
        this.value = null;
    }

    public void setName(ValueExpression name) {
        this.name = name;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public void setMode(ValueExpression mode) {
        LOG.error("The mode is only available when using Facelets, not with JSP.");
    }
}

