/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNodeBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeSelect;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSelectRenderer<T extends AbstractUITreeSelect>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (((AbstractUITreeSelect)component).isDisabled()) {
            return;
        }
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor(component, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        String clientId = component.getClientId(facesContext);
        String name = data.getSelectable().isSingle() ? this.getClientIdWithoutRowIndex(data, clientId) : clientId;
        String parameter = (String)facesContext.getExternalContext().getRequestParameterMap().get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("parameter = '" + parameter + "'");
        }
        boolean selected = clientId.equals(parameter);
        if (!((AbstractUITreeSelect)component).isValueStoredInState()) {
            component.setSubmittedValue((Object)(selected ? "true" : "false"));
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        AbstractUITree tree = ComponentUtils.findAncestor(component, AbstractUITree.class);
        AbstractUITreeNodeBase node = ComponentUtils.findAncestor(component, AbstractUITreeNodeBase.class);
        AbstractUIData data = ComponentUtils.findAncestor((UIComponent)node, AbstractUIData.class);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (data instanceof AbstractUITreeListbox) {
            writer.write(StringUtils.defaultString(((AbstractUITreeSelect)component).getLabel()));
            return;
        }
        String id = component.getClientId(facesContext);
        String currentValue = this.getCurrentValue(facesContext, component);
        boolean checked = ((AbstractUITreeSelect)component).isValueStoredInState() ? data.getSelectedState().isSelected(node.getPath()) : "true".equals(currentValue);
        boolean folder = data.isFolder();
        Selectable selectable = data.getSelectable();
        boolean showFormCheck = ((AbstractUITreeSelect)component).isShowCheckbox() && selectable != Selectable.none && (!selectable.isLeafOnly() || !folder);
        writer.startElement(HtmlElements.TOBAGO_TREE_SELECT);
        writer.writeClassAttribute(component.getCustomClass(), showFormCheck ? BootstrapClass.FORM_CHECK_INLINE : null, showFormCheck && selectable.isMulti() ? BootstrapClass.FORM_CHECK : null, showFormCheck && selectable.isSingle() ? BootstrapClass.FORM_CHECK : null);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (showFormCheck) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INPUT);
            if (selectable.isSingle()) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                writer.writeNameAttribute(this.getClientIdWithoutRowIndex(data, id));
            } else {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                writer.writeNameAttribute(id);
            }
            writer.writeAttribute(HtmlAttributes.VALUE, id, false);
            writer.writeIdAttribute(id);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
            writer.endElement(HtmlElements.INPUT);
        }
        String label = ((AbstractUITreeSelect)component).getLabel();
        writer.startElement(HtmlElements.LABEL);
        writer.writeClassAttribute(showFormCheck ? BootstrapClass.FORM_CHECK_LABEL : null);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.writeAttribute(HtmlAttributes.FOR, id, false);
        writer.writeText(label);
        writer.endElement(HtmlElements.LABEL);
        if (showFormCheck) {
            Map<ClientBehaviors, Command> other;
            CommandMap behaviorCommands = this.getBehaviorCommands(facesContext, (ClientBehaviorHolder)component);
            if (behaviorCommands != null && (other = behaviorCommands.getOther()) != null) {
                Command change = other.get((Object)ClientBehaviors.change);
                change.setExecute(change.getExecute() + " " + tree.getBaseClientId(facesContext));
                change.setRender(change.getRender() + " " + tree.getBaseClientId(facesContext));
            }
            this.encodeBehavior(writer, behaviorCommands);
        }
        writer.endElement(HtmlElements.TOBAGO_TREE_SELECT);
    }

    private String getClientIdWithoutRowIndex(AbstractUIData data, String id) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return id.substring(0, id.indexOf("" + separatorChar + data.getRowIndex() + separatorChar));
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
    }
}

