/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.component.AbstractUITab;
import org.apache.myfaces.tobago.internal.component.AbstractUITabGroup;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.model.SwitchType;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class TabGroupRenderer<T extends AbstractUITabGroup>
extends RendererBase<T>
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String INDEX_POSTFIX = "::index";

    public void processEvent(ComponentSystemEvent event) {
        AbstractUITabGroup tabGroup = (AbstractUITabGroup)event.getComponent();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ClientBehaviors tabChange = ClientBehaviors.tabChange;
        boolean immediate = tabGroup.isImmediate();
        switch (tabGroup.getSwitchType()) {
            case none: {
                break;
            }
            case client: {
                break;
            }
            case reloadTab: {
                AjaxBehavior ajaxBehavior = new AjaxBehavior();
                Set<CallSite> ids = Collections.singleton(UINamingContainer.getSeparatorChar((FacesContext)facesContext) + tabGroup.getClientId(facesContext));
                ajaxBehavior.setExecute(ids);
                ajaxBehavior.setRender(ids);
                ajaxBehavior.setImmediate(immediate);
                tabGroup.addClientBehavior(tabChange.getJsEvent(), (ClientBehavior)ajaxBehavior);
                break;
            }
            case reloadPage: {
                AbstractUIEvent component = (AbstractUIEvent)ComponentUtils.createComponent(facesContext, Tags.event.componentType(), RendererTypes.Event, tabGroup.getId() + "_tabChange");
                component.setEvent(tabChange);
                tabGroup.getChildren().add(component);
                EventBehavior eventBehavior = new EventBehavior();
                eventBehavior.setFor(component.getId());
                eventBehavior.setImmediate(immediate);
                tabGroup.addClientBehavior(tabChange.getJsEvent(), (ClientBehavior)eventBehavior);
                break;
            }
            default: {
                LOG.error("Unknown switch type: '{}'", (Object)tabGroup.getSwitchType());
            }
        }
    }

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        int oldIndex = ((AbstractUITabGroup)component).getRenderedIndex();
        String clientId = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String newValue = (String)parameters.get(clientId + INDEX_POSTFIX);
        try {
            int newIndex = Integer.parseInt(newValue);
            if (newIndex != oldIndex) {
                TabChangeEvent event = new TabChangeEvent((UIComponent)component, oldIndex, newIndex);
                ((AbstractUITabGroup)component).queueEvent((FacesEvent)event);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Can't parse newIndex: '" + newValue + "'");
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T uiComponent) throws IOException {
        int selectedIndex = this.ensureRenderedSelectedIndex(facesContext, (AbstractUITabGroup)uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        String hiddenId = clientId + INDEX_POSTFIX;
        SwitchType switchType = ((AbstractUITabGroup)uiComponent).getSwitchType();
        Markup markup = uiComponent.getMarkup();
        boolean autoSpacing = uiComponent.getAutoSpacing(facesContext);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TOBAGO_TAB_GROUP);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(BootstrapClass.CARD, autoSpacing ? TobagoClass.AUTO__SPACING : null, uiComponent.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, uiComponent);
        writer.writeAttribute(CustomAttributes.SWITCH_TYPE, switchType.name(), false);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)uiComponent);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.VALUE, selectedIndex);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.endElement(HtmlElements.INPUT);
        if (((AbstractUITabGroup)uiComponent).isShowNavigationBar()) {
            this.encodeHeader(facesContext, writer, (AbstractUITabGroup)uiComponent, selectedIndex, switchType);
        }
        this.encodeContent(facesContext, writer, (AbstractUITabGroup)uiComponent, selectedIndex, switchType);
        writer.endElement(HtmlElements.TOBAGO_TAB_GROUP);
    }

    private int ensureRenderedSelectedIndex(FacesContext context, AbstractUITabGroup tabGroup) {
        ValueExpression expression;
        int selectedIndex = tabGroup.getSelectedIndex();
        int index = -1;
        int closestRenderedTabIndex = -1;
        for (UIComponent tab : tabGroup.getChildren()) {
            if (!(tab instanceof AbstractUIPanelBase)) continue;
            if (++index == selectedIndex) {
                if (tab.isRendered()) {
                    return index;
                }
                if (closestRenderedTabIndex > -1) break;
            }
            if (!tab.isRendered()) continue;
            closestRenderedTabIndex = index;
            if (index <= selectedIndex) continue;
            break;
        }
        if (closestRenderedTabIndex == -1) {
            closestRenderedTabIndex = 0;
        }
        if ((expression = tabGroup.getValueExpression(Attributes.selectedIndex.getName())) != null) {
            expression.setValue(context.getELContext(), (Object)closestRenderedTabIndex);
        } else {
            tabGroup.setSelectedIndex(closestRenderedTabIndex);
        }
        return closestRenderedTabIndex;
    }

    private void encodeHeader(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITabGroup tabGroup, int selectedIndex, SwitchType switchType) throws IOException {
        String tabGroupClientId = tabGroup.getClientId(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_HEADER);
        writer.startElement(HtmlElements.UL);
        writer.writeClassAttribute(BootstrapClass.NAV, BootstrapClass.NAV_TABS, BootstrapClass.CARD_HEADER_TABS);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TABLIST.toString(), false);
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof AbstractUITab)) continue;
            AbstractUITab tab = (AbstractUITab)child;
            if (tab.isRendered()) {
                LabelWithAccessKey label = new LabelWithAccessKey(tab);
                UIComponent labelFacet = ComponentUtils.getFacet((UIComponent)tab, Facets.label);
                UIComponent barFacet = ComponentUtils.getFacet((UIComponent)tab, Facets.bar);
                boolean disabled = tab.isDisabled();
                String tabId = tab.getClientId(facesContext);
                Markup markup = tab.getMarkup() != null ? tab.getMarkup() : Markup.NULL;
                FacesMessage.Severity maxSeverity = ComponentUtils.getMaximumSeverityOfChildrenMessages(facesContext, tab);
                if (maxSeverity != null) {
                    markup = markup.add(ComponentUtils.markupOfSeverity(maxSeverity));
                }
                writer.startElement(HtmlElements.TOBAGO_TAB);
                writer.writeIdAttribute(tabId);
                writer.writeClassAttribute(BootstrapClass.NAV_ITEM, barFacet != null ? TobagoClass.BAR : null, disabled ? BootstrapClass.DISABLED : null, tab.getCustomClass());
                writer.writeAttribute(HtmlAttributes.FOR, tabGroupClientId, true);
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PRESENTATION.toString(), false);
                writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.INDEX, index);
                String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)tab);
                if (title != null) {
                    writer.writeAttribute(HtmlAttributes.TITLE, title, true);
                }
                writer.startElement(HtmlElements.A);
                if (!tab.isDisabled()) {
                    writer.writeAttribute(DataAttributes.TOGGLE, "tab", false);
                }
                if (tab.isDisabled()) {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK, BootstrapClass.DISABLED);
                } else if (selectedIndex == index) {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK, BootstrapClass.ACTIVE);
                } else {
                    writer.writeClassAttribute(BootstrapClass.NAV_LINK);
                }
                if (!disabled && switchType == SwitchType.client) {
                    writer.writeAttribute(DataAttributes.TARGET, "#" + this.getTabPanelId(facesContext, tab).replaceAll(":", "\\\\:"), false);
                }
                if (!disabled && label.getAccessKey() != null) {
                    writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
                    AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), tabId);
                }
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TAB.toString(), false);
                if (!disabled) {
                    this.encodeBehavior(writer, facesContext, tab);
                }
                boolean labelEmpty = true;
                String image = tab.getImage();
                if (image != null) {
                    HtmlRendererUtils.encodeIconOrImage(writer, image);
                    labelEmpty = false;
                }
                if (label.getLabel() != null) {
                    writer.startElement(HtmlElements.SPAN);
                    HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
                    writer.endElement(HtmlElements.SPAN);
                    labelEmpty = false;
                }
                if (labelFacet != null) {
                    this.insideBegin(facesContext, Facets.label);
                    labelFacet.encodeAll(facesContext);
                    this.insideEnd(facesContext, Facets.label);
                    labelEmpty = false;
                }
                if (labelEmpty) {
                    writer.writeText(Integer.toString(index + 1));
                }
                writer.endElement(HtmlElements.A);
                if (barFacet != null) {
                    this.insideBegin(facesContext, Facets.bar);
                    writer.startElement(HtmlElements.DIV);
                    barFacet.encodeAll(facesContext);
                    writer.endElement(HtmlElements.DIV);
                    this.insideEnd(facesContext, Facets.bar);
                }
                writer.endElement(HtmlElements.TOBAGO_TAB);
            }
            ++index;
        }
        writer.endElement(HtmlElements.UL);
        writer.endElement(HtmlElements.DIV);
    }

    protected void encodeContent(FacesContext facesContext, TobagoResponseWriter writer, AbstractUITabGroup tabGroup, int selectedIndex, SwitchType switchType) throws IOException {
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.CARD_BODY, BootstrapClass.TAB_CONTENT);
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof AbstractUITab)) continue;
            AbstractUITab tab = (AbstractUITab)child;
            if (tab.isRendered() && (switchType == SwitchType.client || index == selectedIndex) && !tab.isDisabled()) {
                Markup markup = tab.getMarkup();
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.TAB_PANE, index == selectedIndex ? BootstrapClass.ACTIVE : null, tab.getCustomClass());
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.TABPANEL.toString(), false);
                writer.writeIdAttribute(this.getTabPanelId(facesContext, tab));
                writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.INDEX, index);
                tab.encodeAll(facesContext);
                writer.endElement(HtmlElements.DIV);
            }
            ++index;
        }
        writer.endElement(HtmlElements.DIV);
    }

    private String getTabPanelId(FacesContext facesContext, AbstractUITab tab) {
        return tab.getClientId(facesContext) + "::content";
    }
}

