/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.aliasbean;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.jsf.ComponentConfig;
import com.sun.facelets.tag.jsf.ComponentHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.custom.aliasbean.AliasBean;

public class AliasBeanTagHandler
extends ComponentHandler {
    private TagAttribute valueAttr = this.getRequiredAttribute("value");
    private TagAttribute aliasAttr = this.getRequiredAttribute("alias");

    public AliasBeanTagHandler(ComponentConfig tagConfig) {
        super(tagConfig);
    }

    protected void setAttributes(FaceletContext ctx, Object instance) {
        super.setAttributes(ctx, instance);
        Application app = ctx.getFacesContext().getApplication();
        AliasBean aliasBean = (AliasBean)instance;
        String value = this.valueAttr.getValue();
        if (UIComponentTag.isValueReference((String)value)) {
            aliasBean.setValueBinding("value", app.createValueBinding(this.valueAttr.getValue()));
        } else {
            aliasBean.setValue(value);
        }
        String alias = this.aliasAttr.getValue();
        if (UIComponentTag.isValueReference((String)alias)) {
            aliasBean.setValueBinding("alias", app.createValueBinding(this.aliasAttr.getValue()));
        } else {
            aliasBean.setAlias(alias);
        }
    }

    protected void applyNextHandler(FaceletContext ctx, UIComponent component) throws IOException, FacesException, ELException {
        AliasBean aliasBean = (AliasBean)component;
        aliasBean.makeAlias(ctx.getFacesContext());
        super.applyNextHandler(ctx, component);
        aliasBean.removeAlias(ctx.getFacesContext());
    }

    protected void onComponentCreated(FaceletContext faceletcontext, UIComponent component, UIComponent parent) {
        parent.getChildren().add(component);
    }
}

