/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.stylesheet;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.stylesheet.Stylesheet;
import org.apache.myfaces.custom.stylesheet.TextResourceFilter;
import org.apache.myfaces.custom.stylesheet.TextResourceFilterProvider;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class StylesheetRenderer
extends HtmlRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException, FacesException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Stylesheet stylesheet = (Stylesheet)component;
        ResponseWriter writer = context.getResponseWriter();
        String path = stylesheet.getPath();
        if (stylesheet.isInline()) {
            String text;
            if (!path.startsWith("/")) {
                throw new FacesException("Inline stylesheets require absolute resource path");
            }
            writer.startElement("style", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            if (stylesheet.isFiltered()) {
                TextResourceFilter.ResourceInfo info = TextResourceFilter.getInstance(context).getOrCreateFilteredResource(context, path);
                text = info.getText();
            } else {
                text = RendererUtils.loadResourceFile(context, path);
            }
            if (text != null) {
                writer.writeText((Object)text, null);
            }
            writer.endElement("style");
        } else {
            String stylesheetPath;
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            if (stylesheet.isFiltered()) {
                if (!path.startsWith("/")) {
                    throw new FacesException("Filtered stylesheets require absolute resource path");
                }
                TextResourceFilter.getInstance(context).getOrCreateFilteredResource(context, path);
                String nastyPathHack = path.substring(1);
                stylesheetPath = AddResourceFactory.getInstance(context).getResourceUri(context, TextResourceFilterProvider.class, nastyPathHack, true);
            } else {
                stylesheetPath = context.getApplication().getViewHandler().getResourceURL(context, path);
            }
            writer.writeURIAttribute("href", (Object)stylesheetPath, "path");
            writer.endElement("link");
        }
    }
}

