/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceComponentNode;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNode;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNodeParser;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

class ComponentNodeParser
extends BaseNodeParser
implements XMLConstants {
    private List<IncludeNode> _includeNodes = new ArrayList<IncludeNode>();
    private String _type;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ComponentNodeParser.class);

    ComponentNodeParser() {
    }

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
        this._type = attrs.getValue("type");
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("include".equals(localName)) {
            return new IncludeNodeParser();
        }
        return null;
    }

    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if (child == null) {
            return;
        }
        this._includeNodes.add((IncludeNode)child);
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        ArrayList<IncludeNode> nodesWithRefList = new ArrayList<IncludeNode>(this._includeNodes.size());
        ArrayList<IncludeNode> nodesWithSrcList = new ArrayList<IncludeNode>(this._includeNodes.size());
        for (int i = 0; i < this._includeNodes.size(); ++i) {
            IncludeNode node = this._includeNodes.get(i);
            if (node.__getRefId() != null) {
                nodesWithRefList.add(node);
                continue;
            }
            nodesWithSrcList.add(node);
        }
        IncludeNode[] nodesWithRef = nodesWithRefList.toArray(new IncludeNode[nodesWithRefList.size()]);
        IncludeNode[] nodesWithSrc = nodesWithSrcList.toArray(new IncludeNode[nodesWithSrcList.size()]);
        return new DeviceComponentNode(this._type, nodesWithRef, nodesWithSrc);
    }
}

