/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.ComponentNodeParser;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceComponentNode;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceNode;
import org.apache.myfaces.trinidadinternal.agent.parse.NameVersion;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

class DeviceNodeParser
extends BaseNodeParser
implements XMLConstants {
    private String _id;
    private NameVersion _model;
    private String _extendsId;
    private List<DeviceComponentNode> _componentNodes = new ArrayList<DeviceComponentNode>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DeviceNodeParser.class);

    DeviceNodeParser() {
    }

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
        String id = attrs.getValue("id");
        String model = attrs.getValue("model");
        String extendsId = attrs.getValue("extends");
        if (id == null && model == null || id != null && id.trim().length() <= 0 || model != null && model.trim().length() <= 0) {
            _LOG.warning("ELEMENT_MISSING_ATTRIBUTES", (Object)"device");
        }
        this._id = id;
        this._extendsId = extendsId;
        if (model != null) {
            try {
                this._model = new NameVersion(model);
            }
            catch (ParseException pe) {
                _LOG.warning("UNABLE_PARSE_MODEL_STRING");
            }
        }
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("component".equals(localName)) {
            return new ComponentNodeParser();
        }
        return null;
    }

    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if (child == null) {
            return;
        }
        this._componentNodes.add((DeviceComponentNode)child);
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._id == null && this._model == null) {
            return null;
        }
        DeviceComponentNode[] cNodes = this._componentNodes.toArray(new DeviceComponentNode[this._componentNodes.size()]);
        return new DeviceNode(this._id, this._model, this._extendsId, cNodes);
    }
}

