/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyValueBinding
extends ValueBinding {
    private final String _expression;
    private ValueBinding _binding;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LazyValueBinding.class);

    public static ValueBinding createValueBinding(String expression) {
        Application application;
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        if (factory != null && (application = factory.getApplication()) != null) {
            try {
                return application.createValueBinding(expression);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return new LazyValueBinding(expression);
    }

    private LazyValueBinding(String expression) {
        this._expression = expression;
    }

    public Object getValue(FacesContext context) {
        return this._getValueBinding().getValue(context);
    }

    public void setValue(FacesContext context, Object value) {
        this._getValueBinding().setValue(context, value);
    }

    public boolean isReadOnly(FacesContext context) {
        return this._getValueBinding().isReadOnly(context);
    }

    public Class<?> getType(FacesContext context) {
        return this._getValueBinding().getType(context);
    }

    public String getExpressionString() {
        return this._expression;
    }

    private ValueBinding _getValueBinding() {
        if (this._binding == null) {
            ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            Application application = factory.getApplication();
            try {
                this._binding = application.createValueBinding(this._expression);
            }
            catch (ReferenceSyntaxException rse) {
                _LOG.warning((Throwable)rse);
            }
        }
        return this._binding;
    }
}

