/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.PropertyInstantiator;
import org.apache.myfaces.trinidadinternal.image.encode.ImageEncoder;

public class ImageEncoderManager {
    public static final String GIF_TYPE = "image/gif";
    public static final String PNG_TYPE = "image/png";
    private ArrayMap<String, Object> _encoders = new ArrayMap();
    private ArrayMap<String, String> _extensions = new ArrayMap();
    private static ImageEncoderManager _sDefaultInstance = new ImageEncoderManager();
    private static final String _GIF_EXTENSION = ".gif";
    private static final String _PNG_EXTENSION = ".png";

    private ImageEncoderManager() {
    }

    public static ImageEncoderManager getDefaultImageEncoderManager() {
        return _sDefaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageEncoder getImageEncoder(String type) {
        ImageEncoderManager imageEncoderManager = this;
        synchronized (imageEncoderManager) {
            Object encoder = this._encoders.get((Object)type);
            if (encoder instanceof PropertyInstantiator) {
                encoder = ((PropertyInstantiator)encoder).instantiate();
                assert (encoder instanceof ImageEncoder);
                this._encoders.put((Object)type, encoder);
            }
            return (ImageEncoder)encoder;
        }
    }

    public String getImageExtension(String type) {
        return (String)this._extensions.get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEncoding(String type, String extension, ImageEncoder encoder) {
        ImageEncoderManager imageEncoderManager = this;
        synchronized (imageEncoderManager) {
            this._encoders.put((Object)type, (Object)encoder);
            this._extensions.put((Object)type, (Object)extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEncoding(String type, String extension, String encoderClassName) {
        ImageEncoderManager imageEncoderManager = this;
        synchronized (imageEncoderManager) {
            this._encoders.put((Object)type, (Object)new PropertyInstantiator(encoderClassName));
            this._extensions.put((Object)type, (Object)extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEncoding(String type) {
        ImageEncoderManager imageEncoderManager = this;
        synchronized (imageEncoderManager) {
            this._encoders.remove((Object)type);
            this._extensions.remove((Object)type);
        }
    }

    private static void _registerDefaultEncodings(ImageEncoderManager manager) {
        manager.registerEncoding(GIF_TYPE, _GIF_EXTENSION, "org.apache.myfaces.trinidadinternal.image.encode.DefaultGIFEncoder");
        manager.registerEncoding(PNG_TYPE, _PNG_EXTENSION, "org.apache.myfaces.trinidadinternal.image.encode.DefaultPNGEncoder");
    }

    static {
        ImageEncoderManager._registerDefaultEncodings(_sDefaultInstance);
    }
}

