/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;

public class HTMLEscapes {
    private static String[] _sISO8859_1_Entities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    private static final char _UNICODE_LINE_BREAK = '\u2028';
    private static final char _UNICODE_HYPHENATION_POINT = '\u2027';

    public static String escapeText(String text) {
        int buffIndex;
        int length = text.length();
        int escapedIndex = HTMLEscapes._getEscapedIndex(text);
        if (escapedIndex == length) {
            return text;
        }
        char[] buffer = new char[length * 8];
        for (buffIndex = 0; buffIndex < escapedIndex; ++buffIndex) {
            buffer[buffIndex] = text.charAt(buffIndex);
        }
        for (int i = escapedIndex; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffer[buffIndex++] = ch;
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffer[buffIndex++] = ch;
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HTMLEscapes._addStringToBuffer(buffer, buffIndex, "&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HTMLEscapes._addStringToBuffer(buffer, buffIndex, "&gt;");
                        continue;
                    }
                    buffer[buffIndex++] = ch;
                    continue;
                }
                if (ch == '&') {
                    if (i + 1 < length && text.charAt(i + 1) == '{') {
                        buffer[buffIndex++] = ch;
                        continue;
                    }
                    buffIndex = HTMLEscapes._addStringToBuffer(buffer, buffIndex, "&amp;");
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HTMLEscapes._addStringToBuffer(buffer, buffIndex, "&quot;");
                    continue;
                }
                buffer[buffIndex++] = ch;
                continue;
            }
            buffIndex = HTMLEscapes._addDecRefToBuffer(buffer, buffIndex, ch);
        }
        return new String(buffer, 0, buffIndex);
    }

    public static void writeText(Writer out, char[] buffer, char[] text) throws IOException {
        HTMLEscapes.writeText(out, buffer, text, 0, text.length);
    }

    public static void writeText(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\n') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= end || text[i + 1] != '\r') continue;
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= end || text[i + 1] != '\n') continue;
                    ++i;
                    continue;
                }
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(_sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
            if (ch == '\u2028') {
                out.write("<br>");
                continue;
            }
            if (ch == '\u2027') {
                out.write("<wbr>");
                continue;
            }
            HTMLEscapes._writeDecRef(out, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    public static void writeText(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\n') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= length || text.charAt(i + 1) != '\r') continue;
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= length || text.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(_sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
            if (ch == '\u2028') {
                out.write("<br>");
                continue;
            }
            if (ch == '\u2027') {
                out.write("<wbr>");
                continue;
            }
            HTMLEscapes._writeDecRef(out, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buff, String text) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    if (i + 1 < length && text.charAt(i + 1) == '{') {
                        out.write(ch);
                        continue;
                    }
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                    continue;
                }
                if (ch == '\n') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= length || text.charAt(i + 1) != '\r') continue;
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= length || text.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(_sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
            HTMLEscapes._writeDecRef(out, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    public static void writeAttribute(Writer out, char[] buffer, char[] text) throws IOException {
        HTMLEscapes.writeAttribute(out, buffer, text, 0, text.length);
    }

    public static void writeAttribute(Writer out, char[] buff, char[] text, int start, int length) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                        out.write("&gt;");
                        continue;
                    }
                    buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    if (i + 1 < end && text[i + 1] == '{') {
                        out.write(ch);
                        continue;
                    }
                    out.write("&amp;");
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    out.write("&quot;");
                    continue;
                }
                if (ch == '\n') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= end || text[i + 1] != '\r') continue;
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                    HTMLEscapes._println(out);
                    if (i + 1 >= end || text[i + 1] != '\n') continue;
                    ++i;
                    continue;
                }
                buffIndex = HTMLEscapes._addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
                out.write(38);
                out.write(_sISO8859_1_Entities[ch - 160]);
                out.write(59);
                continue;
            }
            buffIndex = HTMLEscapes._flushBuffer(out, buff, buffIndex);
            HTMLEscapes._writeDecRef(out, ch);
        }
        HTMLEscapes._flushBuffer(out, buff, buffIndex);
    }

    private static int _getEscapedIndex(String text) {
        char ch;
        int i;
        int length = text.length();
        for (i = 0; i < length && (ch = text.charAt(i)) < '\u00a0'; ++i) {
            if (ch >= '?') continue;
            if (ch >= '\'') {
                if (ch < '<' || ch != '<' && ch != '>') continue;
                break;
            }
            if (ch == '&') {
                if (i + 1 >= length || text.charAt(i + 1) != '{') break;
                continue;
            }
            if (ch == '\"') break;
        }
        return i;
    }

    private static int _addStringToBuffer(char[] buffer, int offset, String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            buffer[offset++] = text.charAt(i);
        }
        return offset;
    }

    private static int _addDecRefToBuffer(char[] buffer, int offset, char ch) {
        buffer[offset++] = 38;
        buffer[offset++] = 35;
        int i = ch;
        if (i > 10000) {
            buffer[offset++] = (char)(48 + i / 10000);
            buffer[offset++] = (char)(48 + (i %= 10000) / 1000);
            buffer[offset++] = (char)(48 + (i %= 1000) / 100);
            buffer[offset++] = (char)(48 + (i %= 100) / 10);
            buffer[offset++] = (char)(48 + (i %= 10));
        } else if (i > 1000) {
            buffer[offset++] = (char)(48 + i / 1000);
            buffer[offset++] = (char)(48 + (i %= 1000) / 100);
            buffer[offset++] = (char)(48 + (i %= 100) / 10);
            buffer[offset++] = (char)(48 + (i %= 10));
        } else {
            buffer[offset++] = (char)(48 + i / 100);
            buffer[offset++] = (char)(48 + (i %= 100) / 10);
            buffer[offset++] = (char)(48 + (i %= 10));
        }
        buffer[offset++] = 59;
        return offset;
    }

    private static void _writeDecRef(Writer out, char ch) throws IOException {
        out.write("&#");
        int i = ch;
        if (i > 10000) {
            out.write(48 + i / 10000);
            out.write(48 + (i %= 10000) / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else if (i > 1000) {
            out.write(48 + i / 1000);
            out.write(48 + (i %= 1000) / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        } else {
            out.write(48 + i / 100);
            out.write(48 + (i %= 100) / 10);
            out.write(48 + (i %= 10));
        }
        out.write(59);
    }

    private static int _addToBuffer(Writer out, char[] buffer, int bufferIndex, int bufferLength, char ch) throws IOException {
        if (bufferIndex >= bufferLength) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        buffer[bufferIndex] = ch;
        return bufferIndex + 1;
    }

    private static int _flushBuffer(Writer out, char[] buffer, int bufferIndex) throws IOException {
        if (bufferIndex > 0) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        return bufferIndex;
    }

    private static void _println(Writer out) throws IOException {
        out.write(10);
    }

    private HTMLEscapes() {
    }
}

