/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXEditableValue;
import org.apache.myfaces.trinidad.component.UIXGroup;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelFormLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelFormLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _labelWidthKey;
    private PropertyKey _fieldWidthKey;
    private PropertyKey _rowsKey;
    private PropertyKey _maxColumnsKey;
    private static final Set<String> _UNSUPPORTED_RENDERER_TYPES = new HashSet<String>(64);
    private static final String PANEL_FORM_NEST_LEVEL_KEY = "org.apache.myfaces.trinidadinternal.PanelFormNestLevel";
    private static final int _COLUMNS_DEFAULT = 3;
    private static final Map<String, String> _RESOURCE_KEY_SIDE_BY_SIDE_MAP;
    private static final Map<String, String> _RESOURCE_KEY_STACKED_MAP;

    public PanelFormLayoutRenderer() {
        super(CorePanelFormLayout.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._labelWidthKey = type.findKey("labelWidth");
        this._fieldWidthKey = type.findKey("fieldWidth");
        this._rowsKey = type.findKey("rows");
        this._maxColumnsKey = type.findKey("maxColumns");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, arc, bean, "af|panelFormLayout");
    }

    private Object _getLabelWidth(FacesBean bean) {
        return bean.getProperty(this._labelWidthKey);
    }

    private Object _getFieldWidth(FacesBean bean) {
        return bean.getProperty(this._fieldWidthKey);
    }

    private Number _getRows(FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    private Number _getMaxColumns(FacesBean bean) {
        return (Number)bean.getProperty(this._maxColumnsKey);
    }

    private int _getColumnsDefault() {
        return 3;
    }

    private boolean _isFullRow(UIComponent component) {
        String rendererType = component.getRendererType();
        if (component instanceof UIXEditableValue) {
            return !_UNSUPPORTED_RENDERER_TYPES.contains(rendererType);
        }
        if ("org.apache.myfaces.trinidad.Panel".equals(component.getFamily())) {
            return "org.apache.myfaces.trinidad.LabelAndMessage".equals(rendererType) || "org.apache.myfaces.trinidad.rich.LabelAndMessage".equals(rendererType);
        }
        return false;
    }

    @Override
    protected String getDefaultStyleClass(FacesBean bean) {
        return "AFLabelText";
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        Number rowsNumber;
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        int maxColumns = 0;
        Number maxColumnsNumber = this._getMaxColumns(bean);
        maxColumns = maxColumnsNumber != null ? maxColumnsNumber.intValue() : this._getColumnsDefault();
        int rows = 0;
        if (PanelFormLayoutRenderer.isPDA((RenderingContext)arc)) {
            maxColumns = 1;
        }
        if ((rowsNumber = this._getRows(bean)) == null) {
            rows = Integer.MAX_VALUE;
        } else {
            rows = rowsNumber.intValue();
            if (rows < 1) {
                rows = Integer.MAX_VALUE;
            }
        }
        List<Object> footerComponents = null;
        UIComponent footerFacetComponent = component.getFacet("footer");
        if (footerFacetComponent != null) {
            if (footerFacetComponent instanceof UIXGroup) {
                if (footerFacetComponent.isRendered()) {
                    footerComponents = footerFacetComponent.getChildren();
                }
            } else {
                footerComponents = new ArrayList<UIComponent>();
                footerComponents.add(footerFacetComponent);
            }
        }
        this._encodeChildren(context, arc, component, bean, footerComponents, maxColumns, rows);
        rw.endElement("div");
    }

    private void _encodeChildren(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<UIComponent> footerComponents, int maxColumns, int rows) throws IOException {
        boolean startAlignedLabels;
        Map requestMap = context.getExternalContext().getRequestMap();
        Integer nestLevelObject = (Integer)requestMap.get(PANEL_FORM_NEST_LEVEL_KEY);
        int nestLevel = 0;
        if (nestLevelObject != null) {
            nestLevel = nestLevelObject + 1;
        }
        requestMap.put(PANEL_FORM_NEST_LEVEL_KEY, nestLevel);
        List childComponents = component.getChildren();
        FormItemInfo visibleFormItemInfo = this._extractVisibleItems(childComponents);
        List<FormItem> visibleFormItems = visibleFormItemInfo.getFormItems();
        int totalFormItemCount = visibleFormItemInfo.getTotalFormItemCount();
        int totalFooterItemCount = 0;
        List<FormItem> visibleFooterItems = null;
        if (footerComponents != null) {
            FormItemInfo visibleFooterItemInfo = this._extractVisibleItems(footerComponents);
            visibleFooterItems = visibleFooterItemInfo.getFormItems();
            totalFooterItemCount = visibleFooterItemInfo.getTotalFormItemCount();
        }
        int actualColumns = maxColumns;
        int actualRows = rows;
        boolean bl = startAlignedLabels = nestLevel == 0;
        if (!startAlignedLabels || totalFormItemCount == 0) {
            actualColumns = 1;
            actualRows = Integer.MAX_VALUE;
        } else if (actualColumns == 1) {
            actualRows = Integer.MAX_VALUE;
        } else {
            Dimension actualResults = PanelFormLayoutRenderer._computeActualRowsAndColumns(actualRows, actualColumns, totalFormItemCount, visibleFormItems);
            actualRows = (int)actualResults.getHeight();
            actualColumns = (int)actualResults.getWidth();
        }
        if (actualColumns < 1) {
            return;
        }
        String labelWidth = (String)this._getLabelWidth(bean);
        String fieldWidth = (String)this._getFieldWidth(bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        String mainLabelWidth = null;
        String mainFieldWidth = null;
        String footerLabelWidth = null;
        String footerFieldWidth = null;
        if (startAlignedLabels) {
            FormWidths effectiveWidths = this._computeEffectiveWidths(labelWidth, fieldWidth, actualColumns);
            mainLabelWidth = effectiveWidths.getMainLabelWidth();
            mainFieldWidth = effectiveWidths.getMainFieldWidth();
            footerLabelWidth = effectiveWidths.getFooterLabelWidth();
            footerFieldWidth = effectiveWidths.getFooterFieldWidth();
            rw.writeAttribute("style", (Object)("width: " + effectiveWidths.getOverallWidth()), null);
        } else {
            rw.writeAttribute("style", (Object)"width: 100%", null);
        }
        rw.startElement("tbody", null);
        this._encodeFormColumns(context, arc, rw, startAlignedLabels, mainLabelWidth, mainFieldWidth, actualRows, actualColumns, 1, visibleFormItems);
        if (totalFooterItemCount > 0) {
            this._encodeFormColumns(context, arc, rw, startAlignedLabels, footerLabelWidth, footerFieldWidth, totalFooterItemCount, 1, actualColumns, visibleFooterItems);
        }
        if (nestLevel == 0) {
            requestMap.remove(PANEL_FORM_NEST_LEVEL_KEY);
        } else {
            requestMap.put(PANEL_FORM_NEST_LEVEL_KEY, nestLevel - 1);
        }
        rw.endElement("tbody");
        rw.endElement("table");
    }

    private FormItemInfo _extractVisibleItems(List<UIComponent> children) {
        FormItemInfo formItemInfo = new FormItemInfo();
        int totalFormItemCount = 0;
        for (UIComponent child : children) {
            if (!child.isRendered()) continue;
            if (child instanceof UIXGroup) {
                List groupChildren = child.getChildren();
                int visibleChildrenCount = 0;
                for (UIComponent groupChild : groupChildren) {
                    if (!groupChild.isRendered()) continue;
                    ++visibleChildrenCount;
                }
                if (visibleChildrenCount <= 0) continue;
                totalFormItemCount += visibleChildrenCount;
                formItemInfo.add(child, visibleChildrenCount, true);
                continue;
            }
            ++totalFormItemCount;
            formItemInfo.add(child, 1, false);
        }
        formItemInfo.setTotalFormItemCount(totalFormItemCount);
        return formItemInfo;
    }

    private static Dimension _computeActualRowsAndColumns(int guessRows, int guessColumns, int totalFormItemCount, List<FormItem> visibleItems) {
        int actualRows = guessRows;
        int actualColumns = guessColumns;
        actualRows = (int)Math.max((double)actualRows, Math.ceil((double)totalFormItemCount / (double)actualColumns));
        int visibleItemsLength = visibleItems.size();
        boolean itemsWillFit = false;
        while (!itemsWillFit) {
            int currentItemIndex = 0;
            block1: for (int col = 0; col < actualColumns && !itemsWillFit; ++col) {
                int itemSize;
                for (int currentRow = 0; currentRow < actualRows; currentRow += itemSize) {
                    FormItem item = visibleItems.get(currentItemIndex);
                    itemSize = item.getSize();
                    if (currentRow != 0 && currentRow + itemSize > actualRows) continue block1;
                    if (++currentItemIndex < visibleItemsLength) continue;
                    actualColumns = 1 + col;
                    itemsWillFit = true;
                    continue block1;
                }
            }
            if (itemsWillFit) continue;
            ++actualRows;
        }
        return new Dimension(actualColumns, actualRows);
    }

    private FormWidths _computeEffectiveWidths(String labelWidth, String fieldWidth, int actualColumns) {
        int percentCharIndex;
        String effectiveLabelWidth = null;
        String effectiveFieldWidth = null;
        String effectiveFooterLabelWidth = null;
        String effectiveFooterFieldWidth = null;
        String outerTableWidth = "100%";
        double labelRatio = 1.0;
        double fieldRatio = 1.0;
        if (labelWidth != null) {
            percentCharIndex = labelWidth.indexOf("%");
            if (percentCharIndex == -1) {
                effectiveFooterLabelWidth = effectiveLabelWidth = labelWidth + "px";
            } else {
                labelRatio = Double.valueOf(labelWidth.substring(0, percentCharIndex));
            }
        }
        if (fieldWidth != null) {
            percentCharIndex = fieldWidth.indexOf("%");
            if (percentCharIndex == -1) {
                effectiveFieldWidth = fieldWidth + "px";
            } else {
                fieldRatio = Double.valueOf(fieldWidth.substring(0, percentCharIndex));
            }
        }
        if (labelWidth != null && effectiveLabelWidth == null && fieldWidth != null && effectiveFieldWidth == null) {
            double ratioTotal = (labelRatio + fieldRatio) / 100.0;
            double effectiveLabelWidthDouble = labelRatio / ratioTotal;
            effectiveLabelWidth = Math.floor(effectiveLabelWidthDouble) + "%";
            effectiveFieldWidth = Math.floor(fieldRatio / ratioTotal) + "%";
            int footerLabel = (int)Math.floor(effectiveLabelWidthDouble / (double)actualColumns);
            int footerField = 100 - footerLabel;
            effectiveFooterLabelWidth = footerLabel + "%";
            effectiveFooterFieldWidth = footerField + "%";
        } else if (labelWidth != null && effectiveLabelWidth == null) {
            effectiveLabelWidth = labelWidth;
            effectiveFooterLabelWidth = Math.floor(labelRatio / (double)actualColumns) + "%";
        } else if (fieldWidth != null && effectiveFieldWidth == null) {
            effectiveFieldWidth = fieldWidth;
        } else if (labelWidth != null && fieldWidth != null) {
            int labelPixels = Integer.valueOf(labelWidth);
            int fieldPixels = Integer.valueOf(fieldWidth);
            int outerTablePixels = (labelPixels + fieldPixels) * actualColumns;
            outerTableWidth = outerTablePixels + "px";
            effectiveFooterFieldWidth = outerTablePixels - labelPixels + "px";
        } else {
            outerTableWidth = "auto";
        }
        return new FormWidths(effectiveLabelWidth, effectiveFieldWidth, effectiveFooterLabelWidth, effectiveFooterFieldWidth, outerTableWidth);
    }

    private void _encodeFormColumns(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean startAlignedLabels, String effectiveLabelWidth, String effectiveFieldWidth, int actualRows, int actualColumns, int colSpan, List<FormItem> visibleItems) throws IOException {
        if (visibleItems.isEmpty()) {
            return;
        }
        rw.startElement("tr", null);
        int currentItemIndex = 0;
        int visibleItemsLength = visibleItems.size();
        String outerColumnWidth = Math.floor(100.0 / (double)actualColumns) + "%";
        for (int col = 0; col < actualColumns; ++col) {
            int itemSize;
            rw.startElement("td", null);
            PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelFormLayout::column");
            rw.writeAttribute("colspan", (Object)colSpan, null);
            if (col < actualColumns - 1) {
                rw.writeAttribute("width", (Object)outerColumnWidth, null);
            }
            rw.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
            rw.startElement("tbody", null);
            if (startAlignedLabels) {
                rw.startElement("tr", null);
                rw.startElement("td", null);
                if (effectiveLabelWidth != null) {
                    rw.writeAttribute("style", (Object)("width: " + effectiveLabelWidth), null);
                }
                rw.endElement("td");
                rw.startElement("td", null);
                if (effectiveFieldWidth != null) {
                    rw.writeAttribute("style", (Object)("width: " + effectiveFieldWidth), null);
                }
                rw.endElement("td");
                rw.endElement("tr");
            }
            boolean groupSeparatorNeeded = false;
            for (int currentRow = 0; currentRow < actualRows; currentRow += itemSize) {
                FormItem item = visibleItems.get(currentItemIndex);
                UIComponent itemChild = item.getChild();
                itemSize = item.getSize();
                boolean isGroup = item.isGroup();
                int sizeAfterThis = currentRow + itemSize;
                if (currentRow != 0 && sizeAfterThis > actualRows) break;
                if (isGroup) {
                    if (currentRow > 0) {
                        PanelFormLayoutRenderer._encodeGroupDivider(context, arc, rw, startAlignedLabels);
                    }
                    groupSeparatorNeeded = true;
                    List groupChildren = itemChild.getChildren();
                    for (UIComponent groupChild : groupChildren) {
                        if (!groupChild.isRendered()) continue;
                        this._encodeFormItem(context, arc, rw, startAlignedLabels, groupChild);
                    }
                    continue;
                }
                if (groupSeparatorNeeded) {
                    groupSeparatorNeeded = false;
                    PanelFormLayoutRenderer._encodeGroupDivider(context, arc, rw, startAlignedLabels);
                }
                this._encodeFormItem(context, arc, rw, startAlignedLabels, itemChild);
                if (++currentItemIndex < visibleItemsLength) continue;
                break;
            }
            rw.endElement("tbody");
            rw.endElement("table");
            rw.endElement("td");
        }
        rw.endElement("tr");
    }

    private static void _encodeGroupDivider(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean startAlignedLabels) throws IOException {
        rw.startElement("tr", null);
        rw.startElement("td", null);
        if (startAlignedLabels) {
            rw.writeAttribute("colspan", (Object)"2", null);
        }
        rw.startElement("div", null);
        PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelFormLayout::separator");
        rw.endElement("div");
        rw.endElement("td");
        rw.endElement("tr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _encodeFormItem(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean startAlignedLabels, UIComponent item) throws IOException {
        boolean isFullRow = this._isFullRow(item);
        if (isFullRow) {
            PanelFormLayoutRenderer._encodeBeforeLabelTd(context, arc, rw, startAlignedLabels);
            Map originalResourceKeyMap = arc.getSkinResourceKeyMap();
            try {
                if (startAlignedLabels) {
                    arc.setSkinResourceKeyMap(_RESOURCE_KEY_SIDE_BY_SIDE_MAP);
                } else {
                    arc.setSkinResourceKeyMap(_RESOURCE_KEY_STACKED_MAP);
                }
                this.encodeChild(context, item);
            }
            finally {
                arc.setSkinResourceKeyMap(originalResourceKeyMap);
            }
            PanelFormLayoutRenderer._encodeAfterFieldTd(rw, startAlignedLabels);
        } else if (startAlignedLabels) {
            rw.startElement("tr", null);
            rw.startElement("td", null);
            rw.endElement("td");
            rw.startElement("td", null);
            PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelFormLayout::content-cell");
            this.encodeChild(context, item);
            rw.endElement("td");
            rw.endElement("tr");
        } else {
            rw.startElement("tr", null);
            rw.startElement("td", null);
            PanelFormLayoutRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelFormLayout::content-cell");
            this.encodeChild(context, item);
            rw.endElement("td");
            rw.endElement("tr");
        }
    }

    private static void _encodeBeforeLabelTd(FacesContext context, RenderingContext arc, ResponseWriter rw, boolean startAlignedLabels) throws IOException {
        rw.startElement("tr", null);
        if (!startAlignedLabels) {
            rw.startElement("td", null);
            rw.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
            rw.startElement("tbody", null);
            rw.startElement("tr", null);
        }
    }

    protected static boolean encodeBetweenLabelAndFieldCells(FacesContext context, RenderingContext arc, ResponseWriter rw) throws IOException {
        Map requestMap = context.getExternalContext().getRequestMap();
        Integer nestLevelObject = (Integer)requestMap.get(PANEL_FORM_NEST_LEVEL_KEY);
        if (nestLevelObject != null && nestLevelObject > 0) {
            rw.endElement("tr");
            rw.startElement("tr", null);
            return true;
        }
        return false;
    }

    private static void _encodeAfterFieldTd(ResponseWriter rw, boolean startAlignedLabels) throws IOException {
        if (!startAlignedLabels) {
            rw.endElement("tr");
            rw.endElement("tbody");
            rw.endElement("table");
            rw.endElement("td");
        }
        rw.endElement("tr");
    }

    static {
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.Hidden");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.Shuttle");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.rich.Hidden");
        _UNSUPPORTED_RENDERER_TYPES.add("org.apache.myfaces.trinidad.rich.Shuttle");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP = new HashMap<String, String>();
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFLabelText", "af|panelFormLayout::label-cell");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFContentCell", "af|panelFormLayout::content-cell");
        _RESOURCE_KEY_SIDE_BY_SIDE_MAP.put("AFComponentMessageCell", "af|panelFormLayout::message-cell");
        _RESOURCE_KEY_STACKED_MAP = new HashMap<String, String>();
        _RESOURCE_KEY_STACKED_MAP.put("AFLabelText", "af|panelFormLayout::label-stacked-cell");
        _RESOURCE_KEY_STACKED_MAP.put("AFContentCell", "af|panelFormLayout::content-cell");
        _RESOURCE_KEY_STACKED_MAP.put("AFComponentMessageCell", "af|panelFormLayout::message-cell");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FormItemInfo {
        private List<FormItem> _formItems = new ArrayList<FormItem>();
        private int _totalFormItemCount;

        FormItemInfo() {
        }

        void add(UIComponent child, int size, boolean group) {
            this._formItems.add(new FormItem(child, size, group));
        }

        List<FormItem> getFormItems() {
            return this._formItems;
        }

        int getTotalFormItemCount() {
            return this._totalFormItemCount;
        }

        void setTotalFormItemCount(int totalFormItemCount) {
            this._totalFormItemCount = totalFormItemCount;
        }
    }

    private static class FormItem {
        private UIComponent _child;
        private int _size;
        private boolean _group;

        FormItem(UIComponent child, int size, boolean group) {
            this._child = child;
            this._size = size;
            this._group = group;
        }

        UIComponent getChild() {
            return this._child;
        }

        int getSize() {
            return this._size;
        }

        boolean isGroup() {
            return this._group;
        }
    }

    private static class FormWidths {
        String _mainLabelWidth;
        String _mainFieldWidth;
        String _footerLabelWidth;
        String _footerFieldWidth;
        String _overallWidth;

        FormWidths(String mainLabelWidth, String mainFieldWidth, String footerLabelWidth, String footerFieldWidth, String overallWidth) {
            this._mainLabelWidth = mainLabelWidth;
            this._mainFieldWidth = mainFieldWidth;
            this._footerLabelWidth = footerLabelWidth;
            this._footerFieldWidth = footerFieldWidth;
            this._overallWidth = overallWidth;
        }

        String getMainLabelWidth() {
            return this._mainLabelWidth;
        }

        String getMainFieldWidth() {
            return this._mainFieldWidth;
        }

        String getFooterLabelWidth() {
            return this._footerLabelWidth;
        }

        String getFooterFieldWidth() {
            return this._footerFieldWidth;
        }

        String getOverallWidth() {
            return this._overallWidth;
        }
    }
}

