/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.myfaces.trinidad.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceMap
implements Cloneable {
    private Object[] _namespaces;
    private int _defaultSize;

    public NamespaceMap() {
        this(11);
    }

    public NamespaceMap(int defaultSize) {
        this._defaultSize = defaultSize;
    }

    public void put(String namespace, Object key, Object value) {
        this.__put(namespace, key, value);
    }

    public Object get(String namespace, Object key) {
        Map map = (Map)ArrayMap.get((Object[])this._namespaces, (Object)namespace);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public Object remove(String namespace, Object key) {
        Map map = (Map)ArrayMap.get((Object[])this._namespaces, (Object)namespace);
        if (map != null) {
            Object o = map.remove(key);
            if (map.isEmpty()) {
                this._namespaces = ArrayMap.remove((Object[])this._namespaces, (Object)namespace);
            }
            return o;
        }
        return null;
    }

    public void clear(String namespace) {
        this._namespaces = ArrayMap.remove((Object[])this._namespaces, (Object)namespace);
    }

    public void clear() {
        this._namespaces = null;
    }

    public Iterator<Map<Object, Object>> getNamespaceIterator() {
        Object[] namespaces = this._namespaces;
        if (namespaces == null) {
            return null;
        }
        ArrayList<Map> namespacesList = new ArrayList<Map>();
        for (int i = namespaces.length - 2; i >= 0; i -= 2) {
            namespacesList.add((Map)namespaces[i]);
        }
        return namespacesList.iterator();
    }

    public Iterator<Object> getValueIterator() {
        return new Enum();
    }

    public Iterator<Object> getValueIterator(String namespace) {
        Map map = (Map)ArrayMap.get((Object[])this._namespaces, (Object)namespace);
        if (map == null) {
            return null;
        }
        return map.values().iterator();
    }

    public Iterator<Object> getKeysIterator(String namespace) {
        Map map = (Map)ArrayMap.get((Object[])this._namespaces, (Object)namespace);
        if (map == null) {
            return null;
        }
        return map.keySet().iterator();
    }

    public Object clone() {
        NamespaceMap namespaceMap;
        try {
            namespaceMap = (NamespaceMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        if (this._namespaces != null) {
            int length = this._namespaces.length;
            Object[] namespaces = new Object[length];
            System.arraycopy(this._namespaces, 0, namespaces, 0, length);
            for (int i = 1; i < length; i += 2) {
                HashMap hm = (HashMap)namespaces[i];
                if (hm == null) continue;
                namespaces[i] = hm.clone();
            }
            namespaceMap._namespaces = namespaces;
        }
        return namespaceMap;
    }

    Object __put(String namespace, Object key, Object value) {
        if (value == null) {
            return this.remove(namespace, key);
        }
        HashMap<Object, Object> map = (HashMap<Object, Object>)ArrayMap.get((Object[])this._namespaces, (Object)namespace);
        if (map == null) {
            map = new HashMap<Object, Object>(this._defaultSize);
            this._namespaces = ArrayMap.put((Object[])this._namespaces, (Object)namespace, map);
        }
        return map.put(key, value);
    }

    Object[] __getNamespaces() {
        return this._namespaces;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enum
    implements Iterator<Object> {
        private Iterator<Object> _iterator;
        private int _index;

        public Enum() {
            if (NamespaceMap.this._namespaces == null) {
                this._index = -1;
            } else {
                this._index = NamespaceMap.this._namespaces.length + 1;
                this._advanceIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this._index > 0;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this._iterator.next();
            if (!this._iterator.hasNext()) {
                this._advanceIterator();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void _advanceIterator() {
            int index;
            this._index = index = this._index - 2;
            if (index > 0) {
                this._iterator = ((Map)NamespaceMap.this._namespaces[index]).values().iterator();
            }
        }
    }
}

