/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.awt.Font;

public class FontProxy {
    private String _name;
    private int _style;
    private int _size;
    private int _hashCode;
    private static final int _NULL_NAME_HASH = 1001;

    public FontProxy(String name, int style, int size) {
        this._name = name;
        this._style = style;
        this._size = size;
        this._hashCode = this._hashCode();
    }

    public FontProxy(Font font) {
        this(font.getName(), font.getStyle(), font.getSize());
    }

    public String getName() {
        return this._name;
    }

    public int getStyle() {
        return this._style;
    }

    public int getSize() {
        return this._size;
    }

    public Font getFont() {
        return new Font(this._name, this._style, this._size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FontProxy) {
            FontProxy stub = (FontProxy)o;
            return this._style == stub._style && this._size == stub._size && (this._name == null && stub._name == null || this._name != null && this._name.equalsIgnoreCase(stub._name));
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this._name + ",style=" + this._style + ",size=" + this._size + "]";
    }

    void __setName(String name) {
        this._name = name;
        this._hashCode = this._hashCode();
    }

    void __setSize(int size) {
        this._size = size;
        this._hashCode = this._hashCode();
    }

    void __setStyle(int style) {
        this._style = style;
        this._hashCode = this._hashCode();
    }

    private int _hashCode() {
        int hashCode = this._style ^ this._size;
        String name = this._name;
        hashCode = name == null ? (hashCode ^= 0x3E9) : (hashCode ^= name.toLowerCase().hashCode());
        return hashCode;
    }
}

