/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.collection;

import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.collection.UINodeList;

@Deprecated
public class ArrayUINodeList
implements UINodeList {
    private static final int _DEFAULT_SIZE = 5;
    private int _nodeCount;
    private UINode[] _nodes;

    public ArrayUINodeList() {
        this(5);
    }

    public ArrayUINodeList(int initialCapacity) {
        this._nodes = new UINode[initialCapacity];
    }

    public int size(UIXRenderingContext context) {
        return this._nodeCount;
    }

    public UINode getUINode(UIXRenderingContext context, int index) {
        this._checkIndex(index);
        return this._nodes[index];
    }

    public UINode setUINode(int index, UINode node) {
        this._checkIndex(index);
        if (node == null) {
            throw new IllegalArgumentException();
        }
        UINode oldNode = this._nodes[index];
        this._nodes[index] = node;
        return oldNode;
    }

    public void addUINode(UINode node) {
        this.addUINode(this._nodeCount, node);
    }

    public void addUINode(int index, UINode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index > this._nodeCount) {
            throw new IndexOutOfBoundsException();
        }
        int nodeCount = this._nodeCount;
        int availSpace = this._nodes.length;
        if (nodeCount >= availSpace) {
            UINode[] newNodes = new UINode[availSpace * 2];
            System.arraycopy(this._nodes, 0, newNodes, 0, availSpace);
            this._nodes = newNodes;
        }
        if (index < nodeCount) {
            System.arraycopy(this._nodes, index, this._nodes, index + 1, nodeCount - index);
        }
        this._nodes[index] = node;
        ++this._nodeCount;
    }

    public UINode removeUINode(int index) {
        this._checkIndex(index);
        UINode removedNode = this._nodes[index];
        --this._nodeCount;
        if (index != this._nodeCount) {
            System.arraycopy(this._nodes, index + 1, this._nodes, index, this._nodeCount - index);
        }
        this._nodes[this._nodeCount] = null;
        return removedNode;
    }

    public void clearUINodes() {
        int nodeCount = this._nodeCount;
        UINode[] nodes = this._nodes;
        for (int i = 0; i < nodeCount; ++i) {
            nodes[i] = null;
        }
        this._nodeCount = 0;
    }

    public Object clone() {
        try {
            ArrayUINodeList newNodeList = (ArrayUINodeList)super.clone();
            newNodeList._nodes = new UINode[this._nodeCount];
            System.arraycopy(this._nodes, 0, newNodeList._nodes, 0, this._nodeCount);
            return newNodeList;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void trimToSize() {
        if (this._nodeCount < this._nodes.length) {
            UINode[] trimmedNodes = new UINode[this._nodeCount];
            System.arraycopy(this._nodes, 0, trimmedNodes, 0, this._nodeCount);
            this._nodes = trimmedNodes;
        }
    }

    private void _checkIndex(int index) {
        if (index < 0 || index >= this._nodeCount) {
            throw new IndexOutOfBoundsException();
        }
    }
}

